%bcond_with ocf
# it seems there is no usable tcmalloc rpm for x86_64; parts of
# google-perftools don't compile on x86_64, and apparently the
# decision was to not build the package at all, even if tcmalloc
# itself would have worked just fine.
%bcond_with tcmalloc

%if ! (0%{?fedora} > 12 || 0%{?rhel} > 5)
%{!?python_sitelib: %global python_sitelib %(%{__python} -c "from distutils.sysconfig import get_python_lib; print(get_python_lib())")}
%{!?python_sitearch: %global python_sitearch %(%{__python} -c "from distutils.sysconfig import get_python_lib; print(get_python_lib(1))")}
%endif

#################################################################################
# common
#################################################################################
Name:		ceph
Version:	0.56.7
Release:	0%{?dist}
Summary:	User space components of the Ceph file system
License:	GPL-2.0
Group:		System Environment/Base
URL:		http://ceph.com/
Source0:	http://ceph.com/download/%{name}-%{version}.tar.bz2
Requires:	librbd1 = %{version}-%{release}
Requires:	librados2 = %{version}-%{release}
Requires:	libcephfs1 = %{version}-%{release}
Requires(post):	binutils
BuildRoot:      %{_tmppath}/%{name}-%{version}-build
BuildRequires:	gcc-c++
BuildRequires:	libtool
BuildRequires:	boost-devel
BuildRequires:	libedit-devel
BuildRequires:	perl
BuildRequires:	gdbm
BuildRequires:	pkgconfig
BuildRequires:	python
BuildRequires:  libaio-devel
BuildRequires:  libcurl-devel
BuildRequires:  libxml2-devel
BuildRequires:  libuuid-devel

#################################################################################
# specific
#################################################################################
%if 0%{defined suse_version}
BuildRequires:	%insserv_prereq
Recommends:	logrotate
BuildRequires:	mozilla-nss-devel
BuildRequires:	keyutils-devel
BuildRequires:	libatomic-ops-devel
%else
BuildRequires:	nss-devel
BuildRequires:	keyutils-libs-devel
BuildRequires:	libatomic_ops-devel
Requires(post):	chkconfig
Requires(preun):chkconfig
Requires(preun):initscripts
%endif
%if 0%{with tcmalloc}
# use isa so this will not be satisfied by
# google-perftools-devel.i686 on a x86_64 box
# http://rpm.org/wiki/PackagerDocs/ArchDependencies
BuildRequires: google-perftools-devel%{?_isa}
%endif

%description
Ceph is a distributed network file system designed to provide excellent
performance, reliability, and scalability.

#################################################################################
# packages
#################################################################################
%package fuse
Summary:	Ceph fuse-based client
Group:		System Environment/Base
Requires:	%{name}
Requires:	fuse-libs
Requires:	libstdc++
Requires:	libuuid
BuildRequires:	fuse-devel
%description fuse
FUSE based client for Ceph distributed network file system

%package devel
Summary:	Ceph headers
Group:		Development/Libraries
License:	LGPL-2.0
Requires:	%{name} = %{version}-%{release}
Requires:	librados2 = %{version}
Requires:	librbd1 = %{version}
Requires:	libcephfs1 = %{version}
%description devel
This package contains libraries and headers needed to develop programs
that use Ceph.

%package radosgw
Summary:	Rados REST gateway
Group:		Development/Libraries
Requires:	librados2 = %{version}-%{release}
%if 0%{defined suse_version}
BuildRequires:	libexpat-devel
BuildRequires:	FastCGI-devel
Requires:	apache2-mod_fcgid
%else
BuildRequires:	expat-devel
BuildRequires:	fcgi-devel
Requires:	mod_fcgid
%endif
%description radosgw
radosgw is an S3 HTTP REST gateway for the RADOS object store. It is
implemented as a FastCGI module using libfcgi, and can be used in
conjunction with any FastCGI capable web server.

%if %{with ocf}
%package resource-agents
Summary:	OCF-compliant resource agents for Ceph daemons
Group:		System Environment/Base
License:	LGPL-2.0
Requires:	%{name} = %{version}
Requires:	resource-agents
%description resource-agents
Resource agents for monitoring and managing Ceph daemons
under Open Cluster Framework (OCF) compliant resource
managers such as Pacemaker.
%endif

%package -n librados2
Summary:	RADOS distributed object store client library
Group:		System Environment/Libraries
License:	LGPL-2.0
%description -n librados2
RADOS is a reliable, autonomic distributed object storage cluster
developed as part of the Ceph distributed storage system. This is a
shared library allowing applications to access the distributed object
store using a simple file-like interface.

%package -n librbd1
Summary:	RADOS block device client library
Group:		System Environment/Libraries
License:	LGPL-2.0
Requires:	librados2 = %{version}-%{release}
%description -n librbd1
RBD is a block device striped across multiple distributed objects in
RADOS, a reliable, autonomic distributed object storage cluster
developed as part of the Ceph distributed storage system. This is a
shared library allowing applications to manage these block devices.

%package -n libcephfs1
Summary:	Ceph distributed file system client library
Group:		System Environment/Libraries
License:	LGPL-2.0
%description -n libcephfs1
Ceph is a distributed network file system designed to provide excellent
performance, reliability, and scalability. This is a shared library
allowing applications to access a Ceph distributed file system via a
POSIX-like interface.

%package -n python-ceph
Summary:	Python libraries for the Ceph distributed filesystem
Group:		System Environment/Libraries
License:	LGPL-2.0
Requires:	librados2 = %{version}-%{release}
Requires:	librbd1 = %{version}-%{release}
Requires:	libcephfs1 = %{version}-%{release}
%if 0%{defined suse_version}
%py_requires
%endif
%description -n python-ceph
This package contains Python libraries for interacting with Cephs RADOS
object storage.

%package -n rest-bench
Summary:	RESTful benchmark
Group:		System Environment/Libraries
License:	LGPL-2.0
Requires:	librados2 = %{version}-%{release}
Requires:	librbd1 = %{version}-%{release}
Requires:	libcephfs1 = %{version}-%{release}
%description -n rest-bench
RESTful bencher that can be used to benchmark radosgw performance.

%package -n ceph-test
Summary:	Ceph benchmarks and test tools
Group:		System Environment/Libraries
License:	LGPL-2.0
Requires:	librados2 = %{version}-%{release}
Requires:	librbd1 = %{version}-%{release}
Requires:	libcephfs1 = %{version}-%{release}
%description -n ceph-test
This package contains Ceph benchmarks and test tools.

%package -n libcephfs-jni
Summary:	Java Native Interface library for CephFS Java bindings.
Group:		System Environment/Libraries
License:	LGPL-2.0
Requires:	java
Requires:	libcephfs1 = %{version}-%{release}
BuildRequires:  java-devel
%description -n libcephfs-jni
This package contains the Java Native Interface library for CephFS Java
bindings.

%package -n libcephfs-java
Summary:	Java libraries for the Ceph File System.
Group:		System Environment/Libraries
License:	LGPL-2.0
Requires:	java
Requires:	libcephfs-jni = %{version}-%{release}-
BuildRequires:  java-devel
%description -n libcephfs-java
This package contains the Java libraries for the Ceph File System.

%if 0%{?opensuse} || 0%{?suse_version}
%debug_package
%endif

#################################################################################
# common
#################################################################################
%prep
%setup -q

%build
# Find jni.h
for i in /usr/{lib64,lib}/jvm/java/include{,/linux}; do
    [ -d $i ] && java_inc="$java_inc -I$i"
done

./autogen.sh
MY_CONF_OPT=""

MY_CONF_OPT="$MY_CONF_OPT --with-radosgw"

export RPM_OPT_FLAGS=`echo $RPM_OPT_FLAGS | sed -e 's/i386/i486/'`

# be explicit about --with/without-tcmalloc because the
# autoconf default differs from what's needed for rpm
%{configure}	CPPFLAGS="$java_inc" \
		--prefix=/usr \
		--sbindir=/sbin \
		--localstatedir=/var \
		--sysconfdir=/etc \
		--docdir=%{_docdir}/ceph \
		--without-hadoop \
		--with-nss \
		--without-cryptopp \
		--with-rest-bench \
		--with-debug \
		--enable-cephfs-java \
		$MY_CONF_OPT \
		%{?_with_ocf} \
		%{?with_tcmalloc:--with-tcmalloc} %{!?with_tcmalloc:--without-tcmalloc} \
		CFLAGS="$RPM_OPT_FLAGS" CXXFLAGS="$RPM_OPT_FLAGS"

# fix bug in specific version of libedit-devel
%if 0%{defined suse_version}
sed -i -e "s/-lcurses/-lncurses/g" Makefile
sed -i -e "s/-lcurses/-lncurses/g" src/Makefile
sed -i -e "s/-lcurses/-lncurses/g" man/Makefile
%endif

make -j$(getconf _NPROCESSORS_ONLN)

%install
make DESTDIR=$RPM_BUILD_ROOT install
find $RPM_BUILD_ROOT -type f -name "*.la" -exec rm -f {} ';'
find $RPM_BUILD_ROOT -type f -name "*.a" -exec rm -f {} ';'
install -D src/init-ceph $RPM_BUILD_ROOT%{_initrddir}/ceph
install -D src/init-radosgw $RPM_BUILD_ROOT%{_initrddir}/ceph-radosgw
mkdir -p $RPM_BUILD_ROOT/usr/sbin
ln -sf ../../etc/init.d/ceph %{buildroot}/usr/sbin/rcceph
ln -sf ../../etc/init.d/ceph-radosgw %{buildroot}/usr/sbin/rcceph-radosgw
install -m 0644 -D src/logrotate.conf $RPM_BUILD_ROOT%{_sysconfdir}/logrotate.d/ceph
chmod 0644 $RPM_BUILD_ROOT%{_docdir}/ceph/sample.ceph.conf
chmod 0644 $RPM_BUILD_ROOT%{_docdir}/ceph/sample.fetch_config
mkdir -p $RPM_BUILD_ROOT%{_localstatedir}/lib/ceph/tmp/
mkdir -p $RPM_BUILD_ROOT%{_localstatedir}/log/ceph/
mkdir -p $RPM_BUILD_ROOT%{_localstatedir}/run/ceph/
mkdir -p $RPM_BUILD_ROOT%{_sysconfdir}/ceph/

#  Relocate java packages to expected locations in buildroot.
mkdir -p $RPM_BUILD_ROOT/usr/lib/jni
mv $RPM_BUILD_ROOT/usr/lib64/libcephfs_jni.so* $RPM_BUILD_ROOT/usr/lib/jni/.
mkdir -p $RPM_BUILD_ROOT/usr/share/java
mv $RPM_BUILD_ROOT/usr/lib64/libcephfs.jar  $RPM_BUILD_ROOT/usr/share/java/.
mv $RPM_BUILD_ROOT/usr/lib64/libcephfs-test.jar $RPM_BUILD_ROOT/usr/share/java/.

# udev rules
install -m 0644 -D udev/50-rbd.rules $RPM_BUILD_ROOT/lib/udev/rules.d/50-rbd.rules
install -m 0644 -D udev/95-ceph-osd.rules $RPM_BUILD_ROOT/lib/udev/rules.d/95-ceph-osd.rules

%clean
rm -rf $RPM_BUILD_ROOT

%post
/sbin/ldconfig
#/sbin/chkconfig --add ceph

%preun
%if %{defined suse_version}
%stop_on_removal ceph
%endif
if [ $1 = 0 ] ; then
    /sbin/service ceph stop >/dev/null 2>&1
#    /sbin/chkconfig --del ceph
fi

%postun
/sbin/ldconfig
if [ "$1" -ge "1" ] ; then
    /sbin/service ceph condrestart >/dev/null 2>&1 || :
fi
%if %{defined suse_version}
%restart_on_update ceph
%insserv_cleanup
%endif

#################################################################################
# files
#################################################################################
%files
%defattr(-,root,root,-)
%docdir %{_docdir}
%dir %{_docdir}/ceph
%{_docdir}/ceph/sample.ceph.conf
%{_docdir}/ceph/sample.fetch_config
%{_bindir}/ceph
%{_bindir}/cephfs
%{_bindir}/ceph-conf
%{_bindir}/ceph-clsinfo
%{_bindir}/crushtool
%{_bindir}/monmaptool
%{_bindir}/osdmaptool
%{_bindir}/ceph-authtool
%{_bindir}/ceph-syn
%{_bindir}/ceph-run
%{_bindir}/ceph-mon
%{_bindir}/ceph-mds
%{_bindir}/ceph-osd
%{_bindir}/ceph-rbdnamer
%{_bindir}/ceph-dencoder
%{_bindir}/librados-config
%{_bindir}/rados
%{_bindir}/rbd
%{_bindir}/ceph-debugpack
%{_bindir}/ceph-coverage
%{_initrddir}/ceph
/sbin/mkcephfs
/sbin/mount.ceph
%{_libdir}/ceph
/lib/udev/rules.d/50-rbd.rules
/lib/udev/rules.d/95-ceph-osd.rules
%dir %{_sysconfdir}/ceph/
%config %{_sysconfdir}/bash_completion.d/ceph
%config %{_sysconfdir}/bash_completion.d/rados
%config %{_sysconfdir}/bash_completion.d/radosgw-admin
%config %{_sysconfdir}/bash_completion.d/rbd
%config(noreplace) %{_sysconfdir}/logrotate.d/ceph
%{_mandir}/man8/ceph-mon.8*
%{_mandir}/man8/ceph-mds.8*
%{_mandir}/man8/ceph-osd.8*
%{_mandir}/man8/mkcephfs.8*
%{_mandir}/man8/ceph-run.8*
%{_mandir}/man8/ceph-syn.8*
%{_mandir}/man8/ceph-dencoder.8*
%{_mandir}/man8/crushtool.8*
%{_mandir}/man8/osdmaptool.8*
%{_mandir}/man8/monmaptool.8*
%{_mandir}/man8/ceph-conf.8*
%{_mandir}/man8/ceph.8*
%{_mandir}/man8/cephfs.8*
%{_mandir}/man8/mount.ceph.8*
%{_mandir}/man8/rados.8*
%{_mandir}/man8/rbd.8*
%{_mandir}/man8/ceph-rbdnamer.8*
%{_mandir}/man8/ceph-authtool.8*
%{_mandir}/man8/ceph-debugpack.8*
%{_mandir}/man8/ceph-clsinfo.8.gz
%{_mandir}/man8/librados-config.8.gz
%dir %{_localstatedir}/lib/ceph/
%dir %{_localstatedir}/lib/ceph/tmp/
%dir %{_localstatedir}/log/ceph/
%ghost %dir %{_localstatedir}/run/ceph/
%dir %{_sysconfdir}/ceph/
/usr/sbin/rcceph
%dir %{_libdir}/rados-classes
%{_libdir}/rados-classes/libcls_rbd.so*
%{_libdir}/rados-classes/libcls_rgw.so*
%{_libdir}/rados-classes/libcls_lock.so*
%{_libdir}/rados-classes/libcls_kvs.so*
%{_libdir}/rados-classes/libcls_refcount.so*
%{_sbindir}/ceph-disk
%{_sbindir}/ceph-disk-activate
%{_sbindir}/ceph-disk-prepare
%{_sbindir}/ceph-create-keys
/lib/udev/rules.d/95-ceph-osd.rules

#################################################################################
%files fuse
%defattr(-,root,root,-)
%{_bindir}/ceph-fuse
%{_mandir}/man8/ceph-fuse.8*
/sbin/mount.fuse.ceph

#################################################################################
%files devel
%defattr(-,root,root,-)
%dir %{_includedir}/cephfs
%{_includedir}/cephfs/libcephfs.h
%dir %{_includedir}/rados
%{_includedir}/rados/librados.h
%{_includedir}/rados/librados.hpp
%{_includedir}/rados/buffer.h
%{_includedir}/rados/page.h
%{_includedir}/rados/crc32c.h
%dir %{_includedir}/rbd
%{_includedir}/rbd/librbd.h
%{_includedir}/rbd/librbd.hpp
%{_includedir}/rbd/features.h
%{_libdir}/libcephfs.so
%{_libdir}/librbd.so
%{_libdir}/librados.so

#################################################################################
%files radosgw
%defattr(-,root,root,-)
%{_initrddir}/ceph-radosgw
%{_bindir}/radosgw
%{_bindir}/radosgw-admin
%{_mandir}/man8/radosgw.8*
%{_mandir}/man8/radosgw-admin.8*
/usr/sbin/rcceph-radosgw

%post radosgw
/sbin/ldconfig
%if %{defined suse_version}
%fillup_and_insserv -f -y ceph-radosgw
%endif

%preun radosgw
%if %{defined suse_version}
%stop_on_removal ceph-radosgw
%endif

%postun radosgw
/sbin/ldconfig
%if %{defined suse_version}
%restart_on_update ceph-radosgw
%insserv_cleanup
%endif

#################################################################################
%if %{with ocf}
%files resource-agents
%defattr(0755,root,root,-)
/usr/lib/ocf/resource.d/%{name}/*
%endif

#################################################################################
%files -n librados2
%defattr(-,root,root,-)
%{_libdir}/librados.so.*

%post -n librados2
/sbin/ldconfig

%postun -n librados2
/sbin/ldconfig

#################################################################################
%files -n librbd1
%defattr(-,root,root,-)
%{_libdir}/librbd.so.*

%post -n librbd1
/sbin/ldconfig

%postun -n librbd1
/sbin/ldconfig

#################################################################################
%files -n libcephfs1
%defattr(-,root,root,-)
%{_libdir}/libcephfs.so.*

%post -n libcephfs1
/sbin/ldconfig

%postun -n libcephfs1
/sbin/ldconfig

#################################################################################
%files -n python-ceph
%defattr(-,root,root,-)
%{python_sitelib}/rados.py*
%{python_sitelib}/rbd.py*

#################################################################################
%files -n rest-bench
%defattr(-,root,root,-)
%{_bindir}/rest-bench

#################################################################################
%files -n ceph-test
%defattr(-,root,root,-)
%{_bindir}/bench_log
%{_bindir}/dupstore
%{_bindir}/kvstorebench
%{_bindir}/multi_stress_watch
%{_bindir}/omapbench
%{_bindir}/psim
%{_bindir}/radosacl
%{_bindir}/rest-bench
%{_bindir}/rgw_jsonparser
%{_bindir}/rgw_multiparser
%{_bindir}/scratchtool
%{_bindir}/scratchtoolpp
%{_bindir}/smalliobench
%{_bindir}/smalliobenchdumb
%{_bindir}/smalliobenchfs
%{_bindir}/streamtest
%{_bindir}/test_cfuse_cache_invalidate
%{_bindir}/test_cls_lock
%{_bindir}/test_cls_rbd
%{_bindir}/test_cls_refcount
%{_bindir}/test_cls_rgw
%{_bindir}/test_filejournal
%{_bindir}/test_filestore
%{_bindir}/test_filestore_idempotent
%{_bindir}/test_filestore_idempotent_sequence
%{_bindir}/test_filestore_workloadgen
%{_bindir}/test_ioctls
%{_bindir}/test_keyvaluedb_atomicity
%{_bindir}/test_keyvaluedb_iterators
%{_bindir}/test_libcephfs
%{_bindir}/test_librbd
%{_bindir}/test_librbd_fsx
%{_bindir}/test_mon_workloadgen
%{_bindir}/test_mutate
%{_bindir}/test_object_map
%{_bindir}/test_objectcacher_stress
%{_bindir}/test_rados_api_aio
%{_bindir}/test_rados_api_cls
%{_bindir}/test_rados_api_io
%{_bindir}/test_rados_api_list
%{_bindir}/test_rados_api_misc
%{_bindir}/test_rados_api_pool
%{_bindir}/test_rados_api_snapshots
%{_bindir}/test_rados_api_stat
%{_bindir}/test_rados_api_watch_notify
%{_bindir}/test_rewrite_latency
%{_bindir}/test_stress_watch
%{_bindir}/test_trans
%{_bindir}/testcrypto
%{_bindir}/testkeys
%{_bindir}/testmsgr
%{_bindir}/testrados
%{_bindir}/testrados_delete_pools_parallel
%{_bindir}/testrados_list_parallel
%{_bindir}/testrados_open_pools_parallel
%{_bindir}/testrados_watch_notify
%{_bindir}/testsignal_handlers
%{_bindir}/testtimers
%{_bindir}/tpbench
%{_bindir}/xattr_bench

%files -n libcephfs-jni
%defattr(-,root,root,-)
/usr/lib/jni/libcephfs_jni.so*

%files -n libcephfs-java
%defattr(-,root,root,-)
/usr/share/java/libcephfs.jar
/usr/share/java/libcephfs-test.jar

%changelog
