// -*- mode:C++; tab-width:8; c-basic-offset:2; indent-tabs-mode:t -*- 
// vim: ts=8 sw=2 smarttab
/*
 * Ceph - scalable distributed file system
 *
 * Copyright (C) 2004-2006 Sage Weil <sage@newdream.net>
 *
 * This is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1, as published by the Free Software 
 * Foundation.  See file COPYING.
 * 
 */


#ifndef CEPH_MSTATFS_H
#define CEPH_MSTATFS_H

#include <sys/statvfs.h>    /* or <sys/statfs.h> */
#include "messages/PaxosServiceMessage.h"

class MStatfs : public PaxosServiceMessage {
public:
  ceph_fsid_t fsid;

  MStatfs() : PaxosServiceMessage(CEPH_MSG_STATFS, 0) {}
  MStatfs(const ceph_fsid_t& f, tid_t t, version_t v) :
    PaxosServiceMessage(CEPH_MSG_STATFS, v), fsid(f) {
    set_tid(t);
  }

private:
  ~MStatfs() {}

public:
  const char *get_type_name() { return "statfs"; }
  void print(ostream& out) {
    out << "statfs(" << get_tid() << " v" << version << ")";
  }

  void encode_payload(CephContext *cct) {
    paxos_encode();
    ::encode(fsid, payload);
  }
  void decode_payload(CephContext *cct) {
    bufferlist::iterator p = payload.begin();
    paxos_decode(p);
    ::decode(fsid, p);
  }
};

#endif
