/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.ceph;

import com.ceph.fs.CephFileAlreadyExistsException;
import com.ceph.fs.CephStat;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.ceph.CephConfigKeys;
import org.apache.hadoop.fs.ceph.CephFS;
import org.apache.hadoop.fs.ceph.CephInputStream;
import org.apache.hadoop.fs.ceph.CephOutputStream;
import org.apache.hadoop.fs.ceph.CephTalker;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.Progressable;

public class CephFileSystem
extends FileSystem {
    private static final Log LOG = LogFactory.getLog(CephFileSystem.class);
    private URI uri;
    private Path workingDir;
    private CephFS ceph;
    private static final int CEPH_STRIPE_COUNT = 1;
    private TreeMap<Integer, String> datapools = null;

    private Path makeAbsolute(Path path) {
        if (path.isAbsolute()) {
            return path;
        }
        return new Path(this.workingDir, path);
    }

    public URI getUri() {
        return this.uri;
    }

    public void initialize(URI uri, Configuration conf) throws IOException {
        super.initialize(uri, conf);
        if (this.ceph == null) {
            this.ceph = new CephTalker(conf, LOG);
        }
        this.ceph.initialize(uri, conf);
        this.setConf(conf);
        this.uri = URI.create(uri.getScheme() + "://" + uri.getAuthority());
        this.workingDir = this.getHomeDirectory();
    }

    public FSDataInputStream open(Path path, int bufferSize) throws IOException {
        path = this.makeAbsolute(path);
        int fd = this.ceph.open(path, 1, 0);
        CephStat stat = new CephStat();
        this.ceph.fstat(fd, stat);
        CephInputStream istream = new CephInputStream(this.getConf(), this.ceph, fd, stat.size, bufferSize);
        return new FSDataInputStream((InputStream)((Object)istream));
    }

    public void close() throws IOException {
        super.close();
        this.ceph.shutdown();
    }

    public FSDataOutputStream append(Path path, int bufferSize, Progressable progress) throws IOException {
        path = this.makeAbsolute(path);
        if (progress != null) {
            progress.progress();
        }
        int fd = this.ceph.open(path, 68, 0);
        if (progress != null) {
            progress.progress();
        }
        CephOutputStream ostream = new CephOutputStream(this.getConf(), this.ceph, fd, bufferSize);
        return new FSDataOutputStream((OutputStream)ostream, this.statistics);
    }

    public Path getWorkingDirectory() {
        return this.workingDir;
    }

    public void setWorkingDirectory(Path dir) {
        this.workingDir = this.makeAbsolute(dir);
    }

    public boolean mkdirs(Path path, FsPermission perms) throws IOException {
        path = this.makeAbsolute(path);
        boolean result = false;
        try {
            this.ceph.mkdirs(path, perms.toShort());
            result = true;
        }
        catch (CephFileAlreadyExistsException e) {
            result = true;
        }
        return result;
    }

    public FileStatus getFileStatus(Path path) throws IOException {
        path = this.makeAbsolute(path);
        CephStat stat = new CephStat();
        this.ceph.lstat(path, stat);
        FileStatus status = new FileStatus(stat.size, stat.isDir(), (int)this.ceph.get_file_replication(path), stat.blksize, stat.m_time, stat.a_time, new FsPermission((short)stat.mode), System.getProperty("user.name"), null, path.makeQualified((FileSystem)this));
        return status;
    }

    public FileStatus[] listStatus(Path path) throws IOException {
        String[] dirlist = this.ceph.listdir(path = this.makeAbsolute(path));
        if (dirlist != null) {
            FileStatus[] status = new FileStatus[dirlist.length];
            for (int i = 0; i < status.length; ++i) {
                status[i] = this.getFileStatus(new Path(path, dirlist[i]));
            }
            return status;
        }
        if (this.isFile(path)) {
            return new FileStatus[]{this.getFileStatus(path)};
        }
        return null;
    }

    public void setPermission(Path path, FsPermission permission) throws IOException {
        path = this.makeAbsolute(path);
        this.ceph.chmod(path, permission.toShort());
    }

    public void setTimes(Path path, long mtime, long atime) throws IOException {
        path = this.makeAbsolute(path);
        CephStat stat = new CephStat();
        int mask = 0;
        if (mtime != -1L) {
            mask |= 8;
            stat.m_time = mtime;
        }
        if (atime != -1L) {
            mask |= 0x10;
            stat.a_time = atime;
        }
        this.ceph.setattr(path, stat, mask);
    }

    String[] getConfiguredDataPools() {
        String pool_list = this.getConf().get("ceph.data.pools", CephConfigKeys.CEPH_DATA_POOLS_DEFAULT);
        if (pool_list != null) {
            return pool_list.split(",");
        }
        return new String[0];
    }

    int getPoolReplication(String pool_name) throws IOException {
        int pool_id = this.ceph.get_pool_id(pool_name);
        return this.ceph.get_pool_replication(pool_id);
    }

    private String selectDataPool(Path path, int repl_wanted) throws IOException {
        String[] conf_pools;
        TreeMap<Integer, String> pools = new TreeMap<Integer, String>();
        int fd = this.ceph.__open(new Path("/"), 1, 0);
        String pool_name = this.ceph.get_file_pool_name(fd);
        int replication = this.getPoolReplication(pool_name);
        pools.put(new Integer(replication), pool_name);
        for (String name : conf_pools = this.getConfiguredDataPools()) {
            try {
                replication = this.getPoolReplication(name);
                pools.put(new Integer(replication), name);
            }
            catch (IOException e) {
                LOG.warn((Object)("Error looking up replication of pool: " + name + ", " + e));
            }
        }
        Map.Entry entry = pools.ceilingEntry(new Integer(repl_wanted));
        if (entry == null) {
            entry = pools.lastEntry();
        }
        assert (entry != null);
        replication = entry.getKey();
        pool_name = (String)entry.getValue();
        if (replication != repl_wanted) {
            LOG.info((Object)("selectDataPool path=" + path + " pool:repl=" + pool_name + ":" + replication + " wanted=" + repl_wanted));
        }
        return pool_name;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public FSDataOutputStream create(Path path, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        path = this.makeAbsolute(path);
        boolean exists = this.exists(path);
        if (progress != null) {
            progress.progress();
        }
        int flags = 72;
        if (exists) {
            if (!overwrite) throw new FileAlreadyExistsException();
            flags |= 0x10;
        } else {
            Path parent = path.getParent();
            if (parent != null && !this.mkdirs(parent, permission)) {
                throw new IOException("mkdirs failed for " + parent.toString());
            }
        }
        if (progress != null) {
            progress.progress();
        }
        if (blockSize > Integer.MAX_VALUE) {
            blockSize = Integer.MAX_VALUE;
            LOG.info((Object)("blockSize too large. Rounding down to " + blockSize));
        }
        if (blockSize <= 0L) {
            throw new IllegalArgumentException("Invalid block size: " + blockSize);
        }
        int su = this.ceph.get_stripe_unit_granularity();
        if (blockSize % (long)su != 0L) {
            long newBlockSize = blockSize - blockSize % (long)su + (long)su;
            LOG.debug((Object)("fix alignment: blksize " + blockSize + " new blksize " + newBlockSize));
            blockSize = newBlockSize;
        }
        String datapool = this.selectDataPool(path, replication);
        int fd = this.ceph.open(path, flags, permission.toShort(), (int)blockSize, 1, (int)blockSize, datapool);
        if (progress != null) {
            progress.progress();
        }
        CephOutputStream ostream = new CephOutputStream(this.getConf(), this.ceph, fd, bufferSize);
        return new FSDataOutputStream((OutputStream)ostream, this.statistics);
    }

    public boolean rename(Path src, Path dst) throws IOException {
        src = this.makeAbsolute(src);
        dst = this.makeAbsolute(dst);
        try {
            CephStat stat = new CephStat();
            this.ceph.lstat(dst, stat);
            if (stat.isDir()) {
                return this.rename(src, new Path(dst, src.getName()));
            }
            return false;
        }
        catch (FileNotFoundException e) {
            try {
                this.ceph.rename(src, dst);
            }
            catch (FileNotFoundException e2) {
                return false;
            }
            return true;
        }
    }

    public BlockLocation[] getFileBlockLocations(FileStatus file, long start, long len) throws IOException {
        Path abs_path = this.makeAbsolute(file.getPath());
        int fh = this.ceph.open(abs_path, 1, 0);
        if (fh < 0) {
            LOG.error((Object)("getFileBlockLocations:got error " + fh + ", exiting and returning null!"));
            return null;
        }
        CephStat stat = new CephStat();
        this.ceph.fstat(fh, stat);
        long blockSize = stat.blksize;
        BlockLocation[] locations = new BlockLocation[(int)Math.ceil((float)len / (float)blockSize)];
        for (int i = 0; i < locations.length; ++i) {
            long offset = start + (long)i * blockSize;
            long blockStart = start + (long)i * blockSize - start % blockSize;
            locations[i] = new BlockLocation(null, null, blockStart, blockSize);
            LOG.debug((Object)("getFileBlockLocations: location[" + i + "]: " + locations[i]));
        }
        this.ceph.close(fh);
        return locations;
    }

    @Deprecated
    public boolean delete(Path path) throws IOException {
        return this.delete(path, false);
    }

    public boolean delete(Path path, boolean recursive) throws IOException {
        FileStatus status;
        path = this.makeAbsolute(path);
        try {
            status = this.getFileStatus(path);
        }
        catch (FileNotFoundException e) {
            return false;
        }
        if (!status.isDir()) {
            this.ceph.unlink(path);
            return true;
        }
        FileStatus[] dirlist = this.listStatus(path);
        if (dirlist == null) {
            return false;
        }
        if (!recursive && dirlist.length > 0) {
            throw new IOException("Directory " + path.toString() + "is not empty.");
        }
        for (FileStatus fs : dirlist) {
            if (this.delete(fs.getPath(), recursive)) continue;
            return false;
        }
        this.ceph.rmdir(path);
        return true;
    }

    public short getDefaultReplication() {
        return this.ceph.getDefaultReplication();
    }

    public long getDefaultBlockSize() {
        return this.getConf().getLong("ceph.object.size", 0x4000000L);
    }
}

