//  (C) Copyright John Maddock 2006.
//  Use, modification and distribution are subject to the
//  Boost Software License, Version 1.0. (See accompanying file
//  LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

   static const boost::array<boost::array<typename table_type<T>::type, 7>, 500> ibeta_data = { {
      {{ SC_(0.115105740725994110107421875), SC_(27.2666988372802734375), SC_(0.913345992565155029296875), SC_(5.624704191155661855917495760118550518449), SC_(0.4314397017151442751805333868688125395477e-30), SC_(0.9999999999999999999999999999999232955748), SC_(0.7670442516666816870156810539487652961219e-31) }}, 
      {{ SC_(0.4634225666522979736328125), SC_(3.4317314624786376953125), SC_(0.24176712334156036376953125), SC_(0.9303555938707241359170267278058957882937), SC_(0.1886421251845313169553337074104181129545), SC_(0.8314186687138222136543152962911694480678), SC_(0.1685813312861777863456847037088305519322) }}, 
      {{ SC_(0.671531736850738525390625), SC_(23.0631923675537109375), SC_(0.908442795276641845703125), SC_(0.1643292146089890181565750406388380802073), SC_(0.5052411887003343404176234528376913340103e-25), SC_(0.9999999999999999999999996925432949323565), SC_(0.3074567050676435237921994231096931905187e-24) }}, 
      {{ SC_(1.190207004547119140625), SC_(72.69547271728515625), SC_(0.19963125884532928466796875), SC_(0.00559660970823449190019737902600132825008), SC_(0.9534862442725159579596623739736284684983e-9), SC_(0.9999998296314855714196326655015050202504), SC_(0.170368514428580367334498494979749619704e-6) }}, 
      {{ SC_(1.54034411907196044921875), SC_(40.498138427734375), SC_(0.3462987840175628662109375), SC_(0.002938208699935392440146870722865374716805), SC_(0.4756199818667749603935341902256155409499e-9), SC_(0.9999998381258945674369009890750742808727), SC_(0.1618741054325630990109249257191272986861e-6) }}, 
      {{ SC_(1.54871237277984619140625), SC_(81.61170196533203125), SC_(0.678767263889312744140625), SC_(0.0009678001476208569653032183047916640238319), SC_(0.559750588331056488014869497117437903989e-42), SC_(0.9999999999999999999999999999999999999994), SC_(0.5783741506002983362466276981258467292731e-39) }}, 
      {{ SC_(2.251259326934814453125), SC_(4.89832019805908203125), SC_(0.79967319965362548828125), SC_(0.02442974530836840837734643304711539009959), SC_(0.6178004958231200706879909723189065523108e-4), SC_(0.9974774927784456570206007053676991220858), SC_(0.002522507221554342979399294632300877914206) }}, 
      {{ SC_(2.8674151897430419921875), SC_(59.60579681396484375), SC_(0.575251102447509765625), SC_(0.1379388062890870134560096364710423528806e-4), SC_(0.4175062181357307894530268550925291936655e-24), SC_(0.9999999999999999999697325046252222304163), SC_(0.3026749537477776958367907987526182267324e-19) }}, 
      {{ SC_(2.922028064727783203125), SC_(26.592067718505859375), SC_(0.4733414947986602783203125), SC_(0.000115508766121651474024307828538813831237), SC_(0.3796145990560169217472146784816274010906e-9), SC_(0.9999967135537481783877208030551367243803), SC_(0.3286446251821612279196944863275619723855e-5) }}, 
      {{ SC_(3.0540943145751953125), SC_(42.39783477783203125), SC_(0.546926796436309814453125), SC_(0.2096012544527507305106729688625599112948e-4), SC_(0.1877791782437026107953033098682180353671e-16), SC_(0.9999999999991041123359027203750870846506), SC_(0.8958876640972796249129153494479842438984e-12) }}, 
      {{ SC_(3.183284282684326171875), SC_(31.6550426483154296875), SC_(0.077649272978305816650390625), SC_(0.1607872346465483285868910326819359030108e-4), SC_(0.1977878368269834064074165442158816223284e-4), SC_(0.4484060589761797174626811812282881431733), SC_(0.5515939410238202825373188187717118568267) }}, 
      {{ SC_(3.2600824832916259765625), SC_(6.254324436187744140625), SC_(0.743158161640167236328125), SC_(0.003877690538964813730515800489545485233393), SC_(0.1849121735270227071877446919569946133643e-4), SC_(0.9952540157237994764714787832333762033991), SC_(0.004745984276200523528521216766623796600881) }}, 
      {{ SC_(3.360383510589599609375), SC_(52.89206695556640625), SC_(0.81474220752716064453125), SC_(0.4293999091288321831907350544825170972342e-5), SC_(0.219834444785251736057188895022180823046e-40), SC_(0.9999999999999999999999999999999999948804), SC_(0.5119573621504776597210994477995646618901e-35) }}, 
      {{ SC_(3.4446079730987548828125), SC_(66.3605499267578125), SC_(0.096544884145259857177734375), SC_(0.1474102736157956762304488717716147895171e-5), SC_(0.8307589573110103561152668922877179107493e-7), SC_(0.9466497330301024630866270516938583276551), SC_(0.05335026696989753691337294830614167234487) }}, 
      {{ SC_(3.57116794586181640625), SC_(36.129398345947265625), SC_(0.046266771852970123291015625), SC_(0.1377307832566030389205420277524302194542e-5), SC_(0.7311615977995211503865956731396528899981e-5), SC_(0.1585130520872948273412729049865238748685), SC_(0.8414869479127051726587270950134761251315) }}, 
      {{ SC_(3.5762732028961181640625), SC_(80.64510345458984375), SC_(0.92886126041412353515625), SC_(0.5195049488417132478527686360715001708256e-6), SC_(0.2753515092058996575690963489155893940797e-94), SC_(1.0), SC_(0.530026729908584311094876547172139505977e-88) }}, 
      {{ SC_(3.7738864421844482421875), SC_(88.39685821533203125), SC_(0.50323975086212158203125), SC_(0.1936358080461588466938455069456644840687e-6), SC_(0.2398889407764917341676367096721572497995e-29), SC_(0.9999999999999999999999876113337095529831), SC_(0.1238866629044701687424663630369236796346e-22) }}, 
      {{ SC_(4.24311351776123046875), SC_(87.180511474609375), SC_(0.594544112682342529296875), SC_(0.4437344750551262251613273178405984994839e-7), SC_(0.1440454807297923187241336158457814894158e-36), SC_(0.9999999999999999999999999999967537910884), SC_(0.3246208911577068569804118543592340399042e-29) }}, 
      {{ SC_(4.302380084991455078125), SC_(90.84336090087890625), SC_(0.3500487506389617919921875), SC_(0.3088652285368942607072200051700648121738e-7), SC_(0.3690261013058404601783388874804478116026e-20), SC_(0.9999999999998805219664725983124099139968), SC_(0.1194780335274016875900860032189749548454e-12) }}, 
      {{ SC_(4.61713886260986328125), SC_(14.9113979339599609375), SC_(0.081217654049396514892578125), SC_(0.7777055873291569797054048770916368511548e-6), SC_(0.3050394533002200879235444490511467363605e-4), SC_(0.02486139844038035518263312395393841283781), SC_(0.9751386015596196448173668760460615871622) }}, 
      {{ SC_(4.965442657470703125), SC_(82.34554290771484375), SC_(0.3013162314891815185546875), SC_(0.6232388896113233687607109871883895899506e-8), SC_(0.1757129987256299654131721919929978230207e-16), SC_(0.9999999971806477233823653568856711213164), SC_(0.2819352276617634643114328878683629953111e-8) }}, 
      {{ SC_(5.26769924163818359375), SC_(94.65772247314453125), SC_(0.695263326168060302734375), SC_(0.1253627465271932390249428025335036505934e-8), SC_(0.3222623306430773933281977469822481222259e-51), SC_(1.0), SC_(0.2570638722989156911038000229513107483269e-42) }}, 
      {{ SC_(5.39501190185546875), SC_(35.276241302490234375), SC_(0.184897840023040771484375), SC_(0.1209301166284995442719813406613075674954e-6), SC_(0.2280352502477099546779864717478435018705e-7), SC_(0.8413487283667377937115292338183332209645), SC_(0.1586512716332622062884707661816667790355) }}, 
      {{ SC_(5.961885929107666015625), SC_(95.24720001220703125), SC_(0.587086021900177001953125), SC_(0.1538572075523752828118796821074440813526e-9), SC_(0.2000258675867804464202225099585025891472e-39), SC_(0.9999999999999999999999999999986999252699), SC_(0.1300074730127210093509800162113431715462e-29) }}, 
      {{ SC_(5.977954387664794921875), SC_(43.524570465087890625), SC_(0.3404516875743865966796875), SC_(0.1330232014752472065680412448138951627377e-7), SC_(0.1838187070983182316780060409965932424395e-11), SC_(0.9998618336444325666209910880648121429145), SC_(0.0001381663555674333790089119351878570854794) }}, 
      {{ SC_(6.04711818695068359375), SC_(27.766407012939453125), SC_(0.65411365032196044921875), SC_(0.1448258716618381548156837823010682065087e-6), SC_(0.7331873767991696645616237465028962091657e-15), SC_(0.9999999949374558241960009728719676377959), SC_(0.5062544175803999027128032362204089305663e-8) }}, 
      {{ SC_(6.7992763519287109375), SC_(90.44748687744140625), SC_(0.887737333774566650390625), SC_(0.1998993534488701791116031926385820610152e-10), SC_(0.6971997317630963088710683423020133066068e-88), SC_(1.0), SC_(0.3487753810776704370476639121868597367948e-77) }}, 
      {{ SC_(6.88061046600341796875), SC_(29.616764068603515625), SC_(0.815787494182586669921875), SC_(0.2281625605381182233289702097867621117898e-7), SC_(0.1856504037414286050377032409208117834665e-23), SC_(0.9999999999999999186323981885657766556028), SC_(0.8136760181143422334439720929849176822682e-16) }}, 
      {{ SC_(7.14454555511474609375), SC_(93.46026611328125), SC_(0.5949366092681884765625), SC_(0.6261688000720345538602778281565999642712e-11), SC_(0.9596403591635324364962526501236935948176e-40), SC_(0.9999999999999999999999999999846744143264), SC_(0.1532558567359369013326396902913815273371e-28) }}, 
      {{ SC_(7.58542919158935546875), SC_(40.4208526611328125), SC_(0.18398940563201904296875), SC_(0.5710750401537042017349940997959387844794e-9), SC_(0.2303762947100015498104515891135402646609e-9), SC_(0.712551112352717985151979924433686508159), SC_(0.287448887647282014848020075566313491841) }}, 
      {{ SC_(7.596668720245361328125), SC_(76.24213409423828125), SC_(0.285910427570343017578125), SC_(0.8265019986755931648288865085855177284833e-11), SC_(0.3020435737611112373637402768694641871851e-16), SC_(0.9999963455324919155056331119114169870562), SC_(0.3654467508084494366888088583012943772111e-5) }}, 
      {{ SC_(7.817553043365478515625), SC_(85.445098876953125), SC_(0.2395785152912139892578125), SC_(0.2045849138997910846011181882057729206148e-11), SC_(0.6206348438534908303443614446395388099155e-16), SC_(0.9999696646245887662689981969860862011323), SC_(0.3033537541123373100180301391379886772522e-4) }}, 
      {{ SC_(8.11257648468017578125), SC_(37.94188690185546875), SC_(0.379480898380279541015625), SC_(0.4786697989791690183686973181095820391607e-9), SC_(0.5105450174508401841625588085643695311267e-12), SC_(0.9989345451585250300412316485503607267762), SC_(0.001065454841474969958768351449639273223821) }}, 
      {{ SC_(8.34698200225830078125), SC_(90.6944122314453125), SC_(0.644353687763214111328125), SC_(0.3364675517953113000901013402400027278184e-12), SC_(0.8698402891720550493242566122003912414852e-44), SC_(0.99999999999999999999999999999997414787), SC_(0.2585213000572545365092497901594719756978e-31) }}, 
      {{ SC_(8.38213825225830078125), SC_(91.25775146484375), SC_(0.22599919140338897705078125), SC_(0.2928519296858282452714722219455008628279e-12), SC_(0.1777333486814689733291769711180044171708e-16), SC_(0.9999393131666238248657974654220509829647), SC_(0.6068683337617513420253457794901703526372e-4) }}, 
      {{ SC_(8.44358539581298828125), SC_(34.623340606689453125), SC_(0.2511587440967559814453125), SC_(0.443701039522219953578147586202996031252e-9), SC_(0.9513284666103323417345709357843462492944e-10), SC_(0.823446800395401826049653589725327249707), SC_(0.176553199604598173950346410274672750293) }}, 
      {{ SC_(8.551578521728515625), SC_(99.35347747802734375), SC_(0.47097623348236083984375), SC_(0.9491108813882418406411403691391340218337e-13), SC_(0.1251951329728637708212384704748511946219e-31), SC_(0.9999999999999999998680921950976435577979), SC_(0.1319078049023564422021423976447900507394e-18) }}, 
      {{ SC_(9.08232879638671875), SC_(6.788483142852783203125), SC_(0.84073317050933837890625), SC_(0.2530253735758439599396238834500896240932e-4), SC_(0.1710018161376520978407344762789904201606e-6), SC_(0.9932870805673499082587034528485389854982), SC_(0.006712919432650091741296547151461014501845) }}, 
      {{ SC_(9.111347198486328125), SC_(8.621723175048828125), SC_(0.95751106739044189453125), SC_(0.5581733139245863761480262091886625022247e-5), SC_(0.1262573120459230933124347573943433093957e-12), SC_(0.9999999773802677339972476692253597732084), SC_(0.2261973226600275233077464022679157690182e-7) }}, 
      {{ SC_(9.4229335784912109375), SC_(77.64537811279296875), SC_(0.808194696903228759765625), SC_(0.9524570155144056199865395551964281966018e-13), SC_(0.4565434370151736443918038655891867279458e-58), SC_(1.0), SC_(0.4793323263712876342930723505606328765286e-45) }}, 
      {{ SC_(9.64545345306396484375), SC_(22.3419952392578125), SC_(0.3250310420989990234375), SC_(0.1927273294702852349994959071840024548323e-8), SC_(0.1127320113582492064762275103993848682693e-8), SC_(0.6309426614603682093440760069469571263649), SC_(0.3690573385396317906559239930530428736351) }}, 
      {{ SC_(9.67300319671630859375), SC_(28.9689388275146484375), SC_(0.602882802486419677734375), SC_(0.3387330112954271587522113960748178117541e-9), SC_(0.1264185963441989647697159098522605256053e-14), SC_(0.9999962679124760982696760022063593542069), SC_(0.3732087523901730323997793640645793120035e-5) }}, 
      {{ SC_(9.71317768096923828125), SC_(99.40685272216796875), SC_(0.0839129984378814697265625), SC_(0.2314488008585757404811752654298553290829e-14), SC_(0.270313707187334081763305972274999472369e-14), SC_(0.4612716118626361034813232775095335302198), SC_(0.5387283881373638965186767224904664697802) }}, 
      {{ SC_(9.754039764404296875), SC_(54.722057342529296875), SC_(0.01363777182996273040771484375), SC_(0.3368981224301379108838107150715196706969e-19), SC_(0.1110004273353565458512440747737453369747e-11), SC_(0.3035106443212857882581240007478661981264e-7), SC_(0.9999999696489355678714211741875999252134) }}, 
      {{ SC_(9.87122821807861328125), SC_(76.6854095458984375), SC_(0.5060064792633056640625), SC_(0.3902504421774217272554497438780180477894e-13), SC_(0.1132907932372070809565814012629006675206e-27), SC_(0.9999999999999970969720724697928938432078), SC_(0.2903027927530207106156792222169782876577e-14) }}, 
      {{ SC_(10.56292057037353515625), SC_(68.12713623046875), SC_(0.82583439350128173828125), SC_(0.2785817464599403775893181935422048664706e-13), SC_(0.4717252140853610172599941592891955373073e-54), SC_(1.0), SC_(0.1693309845601080580127181291846962653943e-40) }}, 
      {{ SC_(10.62163448333740234375), SC_(49.278961181640625), SC_(0.6798517704010009765625), SC_(0.5958863813529190097697256011414634979471e-12), SC_(0.2288849440125899541446316347103048842469e-27), SC_(0.9999999999999996158916344204370695234889), SC_(0.3841083655795629304765110609039225618465e-15) }}, 
      {{ SC_(10.6652774810791015625), SC_(49.854419708251953125), SC_(0.2400285303592681884765625), SC_(0.4422990963276631606374577229051909674408e-12), SC_(0.5031698677956059771262107115968987085183e-13), SC_(0.8978576045220015559609936952873723304564), SC_(0.1021423954779984440390063047126276695436) }}, 
      {{ SC_(10.67618656158447265625), SC_(50.19744110107421875), SC_(0.52858030796051025390625), SC_(0.4518761400139130213130491583640810461719e-12), SC_(0.201437738631141141470424212178522757797e-20), SC_(0.9999999955421913242206573717392946221685), SC_(0.4457808675779342628260705377831546128942e-8) }}, 
      {{ SC_(10.7769012451171875), SC_(37.481258392333984375), SC_(0.79485189914703369140625), SC_(0.646975771789569508579349635040961226221e-11), SC_(0.4964914536667815249823527165405771180686e-28), SC_(0.9999999999999999923259652785225686792144), SC_(0.767403472147743132078557996820695266472e-17) }}, 
      {{ SC_(11.11192226409912109375), SC_(70.73215484619140625), SC_(0.4427340030670166015625), SC_(0.6203632093352945084996567094765910103772e-14), SC_(0.4936047078287128948131686513371015921329e-23), SC_(0.9999999992043294959982350636294635189767), SC_(0.7956705040017649363705364810232981336917e-9) }}, 
      {{ SC_(11.1202754974365234375), SC_(16.287212371826171875), SC_(0.3125767409801483154296875), SC_(0.1444084880827105833598873002859647716634e-8), SC_(0.7582293180045103178119891941975956585152e-8), SC_(0.1599849763757364153063562226806810539962), SC_(0.8400150236242635846936437773193189460038) }}, 
      {{ SC_(11.7417659759521484375), SC_(32.4963531494140625), SC_(0.4580433666706085205078125), SC_(0.6541379949738736127026537535568566930981e-11), SC_(0.2467161453427888318891073615024870068511e-13), SC_(0.9962425493779973850401884157721807468848), SC_(0.003757450622002614959811584227819253115167) }}, 
      {{ SC_(11.89976787567138671875), SC_(45.603282928466796875), SC_(0.12527024745941162109375), SC_(0.7343675470549631205259840603871381673905e-14), SC_(0.1445731020617901942696801549598873126062e-12), SC_(0.04834012141276706659561379818680486688753), SC_(0.9516598785872329334043862018131951331125) }}, 
      {{ SC_(11.939624786376953125), SC_(11.107936859130859375), SC_(0.97992765903472900390625), SC_(0.1236855625133917838192742812677181831194e-6), SC_(0.1026801911750464939553409817973824818524e-19), SC_(0.999999999999916982880549279551870238859), SC_(0.830171194507204481297611409510827886702e-13) }}, 
      {{ SC_(12.06116199493408203125), SC_(70.715972900390625), SC_(0.76554024219512939453125), SC_(0.9327812564588109856066718781098927286944e-15), SC_(0.2196385270083919350014732372050387947987e-47), SC_(0.9999999999999999999999999999999976453373), SC_(0.2354662740996989134445682126619652642791e-32) }}, 
      {{ SC_(12.33189296722412109375), SC_(25.295597076416015625), SC_(0.2963911592960357666015625), SC_(0.1430384079233545086422442075798357554593e-10), SC_(0.2608129213386147998505707504945413064922e-10), SC_(0.3541858044264816530507626723606877120233), SC_(0.6458141955735183469492373276393122879767) }}, 
      {{ SC_(12.69868183135986328125), SC_(96.88677978515625), SC_(0.0048830057494342327117919921875), SC_(0.2274631895397714334376199506015971238567e-30), SC_(0.6436250806711273698189670869799232318523e-17), SC_(0.3534094558630012306091726356379062630746e-13), SC_(0.9999999999999646590544136998769390827364) }}, 
      {{ SC_(12.80144023895263671875), SC_(88.17254638671875), SC_(0.731749236583709716796875), SC_(0.1600513463255546840178411447275468581372e-16), SC_(0.1225858808089488512156391650822874811212e-53), SC_(0.9999999999999999999999999999999999999234), SC_(0.7659159614915161187588366101009835373041e-37) }}, 
      {{ SC_(12.99062061309814453125), SC_(15.4438419342041015625), SC_(0.1945759356021881103515625), SC_(0.2587781101703819292072418245521947001612e-11), SC_(0.291528868499340400454385937301248543798e-8), SC_(0.0008868713709346840065848185228626715063198), SC_(0.9991131286290653159934151814771373284937) }}, 
      {{ SC_(13.19732952117919921875), SC_(49.030147552490234375), SC_(0.3325150310993194580078125), SC_(0.836807821750677730781836247457631142927e-14), SC_(0.1355217337782138292671525236416076932712e-15), SC_(0.9840630163043200372488915808903253780579), SC_(0.01593698369567996275110841910967462194208) }}, 
      {{ SC_(13.31710052490234375), SC_(7.650397777557373046875), SC_(0.644586086273193359375), SC_(0.6334516998363631798060997294309157441901e-6), SC_(0.5867175170967860406913828309197643581204e-6), SC_(0.5191506973340311769249913932512318048834), SC_(0.4808493026659688230750086067487681951166) }}, 
      {{ SC_(13.6068553924560546875), SC_(80.21114349365234375), SC_(0.2625559866428375244140625), SC_(0.9992299384769147519369814595315761288124e-17), SC_(0.2479250831624222327657818529226482238861e-19), SC_(0.997524979447043305474794182324638778972), SC_(0.002475020552956694525205817675361221028024) }}, 
      {{ SC_(13.6553134918212890625), SC_(84.710968017578125), SC_(0.513298213481903076171875), SC_(0.4552602913635528307038399569663237850965e-17), SC_(0.9526803734074731746813267204211613354766e-32), SC_(0.9999999999999979073940963441101405545443), SC_(0.209260590365588985944545573621935147781e-14) }}, 
      {{ SC_(13.86244487762451171875), SC_(76.17311859130859375), SC_(0.1419721543788909912109375), SC_(0.471777422530245397549754360049288004398e-17), SC_(0.7079580252143472766427264767362043933898e-17), SC_(0.3999010315678698251764087828156171967859), SC_(0.6000989684321301748235912171843828032141) }}, 
      {{ SC_(14.18863391876220703125), SC_(0.4783484041690826416015625), SC_(0.035808108747005462646484375), SC_(0.2181420600534516761479511103223744849247e-21), SC_(0.5252237792285076729676810983455265352419), SC_(0.4153316522985247527631504651619264125478e-21), SC_(0.9999999999999999999995846683477014752472) }}, 
      {{ SC_(14.495479583740234375), SC_(68.02870941162109375), SC_(0.2728257477283477783203125), SC_(0.1583805387717215760690192473852076461233e-16), SC_(0.2685492726820800162158386962306165441572e-18), SC_(0.9833267592065487534269929523991259762928), SC_(0.0166732407934512465730070476008740237072) }}, 
      {{ SC_(14.55389881134033203125), SC_(28.267330169677734375), SC_(0.262285530567169189453125), SC_(0.1368603360178309831063004729451423767005e-12), SC_(0.8423813680373936308911937645321041457644e-12), SC_(0.139761547584285386592630137056317947914), SC_(0.860238452415714613407369862943682052086) }}, 
      {{ SC_(14.92940044403076171875), SC_(23.015605926513671875), SC_(0.1450403034687042236328125), SC_(0.8346816451648677175496669071149149814546e-15), SC_(0.7552948548034490873736089786224782702461e-11), SC_(0.000110498490595455606500103409414485352965), SC_(0.999889501509404544393499896590585514647) }}, 
      {{ SC_(14.98654460906982421875), SC_(19.5107402801513671875), SC_(0.622092902660369873046875), SC_(0.4754015571501058469479017635859747408132e-10), SC_(0.6224329229145444216639234478460144861501e-12), SC_(0.9870764229972386472767835767144023074407), SC_(0.01292357700276135272321642328559769255934) }}, 
      {{ SC_(15.2378025054931640625), SC_(50.319004058837890625), SC_(0.2302330434322357177734375), SC_(0.1358396765418010348485937847284120525806e-15), SC_(0.1336553663882714658160689258595248999831e-15), SC_(0.5040525980177237343896273264202142809274), SC_(0.4959474019822762656103726735797857190726) }}, 
      {{ SC_(15.2721195220947265625), SC_(54.02520751953125), SC_(0.93401730060577392578125), SC_(0.9806622787349997524794563536696797743199e-16), SC_(0.1179746997234395405098481040222145009647e-65), SC_(1.0), SC_(0.1203010478547419972379048746089257476243e-49) }}, 
      {{ SC_(15.36567211151123046875), SC_(52.704280853271484375), SC_(0.848482906818389892578125), SC_(0.1189869504759809721262347397884564905103e-15), SC_(0.1205167248842989509302379987322991677386e-45), SC_(0.999999999999999999999999999998987143343), SC_(0.1012856656988001244779876090333902042448e-29) }}, 
      {{ SC_(15.64049530029296875), SC_(33.579792022705078125), SC_(0.757224500179290771484375), SC_(0.334105890620542432215301754097792702537e-13), SC_(0.1328627163740096418101062638883003542285e-23), SC_(0.9999999999602333511324935915593900751149), SC_(0.39766648867506408440609924885097307802e-10) }}, 
      {{ SC_(15.7613086700439453125), SC_(72.583892822265625), SC_(0.02931735850870609283447265625), SC_(0.597817234080146905146952778275648216168e-26), SC_(0.7113363534516596137475168226678200473187e-18), SC_(0.8404142796233898015967340533693928321288e-8), SC_(0.9999999915958572037661019840326594663061) }}, 
      {{ SC_(16.14847564697265625), SC_(48.818401336669921875), SC_(0.801034510135650634765625), SC_(0.109143584202282289680538262456504541044e-15), SC_(0.4499830497382691554031721903276781483949e-37), SC_(0.9999999999999999999995877146118783410738), SC_(0.4122853881216589261831470291007530731187e-21) }}, 
      {{ SC_(16.2182292938232421875), SC_(92.7492828369140625), SC_(0.2078215181827545166015625), SC_(0.7948632114788365030854995953193570000824e-20), SC_(0.4254667258353576247523665412048381049542e-21), SC_(0.9491925359453163728901600048445871196697), SC_(0.05080746405468362710983999515541288033028) }}, 
      {{ SC_(16.261173248291015625), SC_(64.39609527587890625), SC_(0.12340660393238067626953125), SC_(0.4756133626209864854122181844682389348196e-19), SC_(0.1683563689735547723818589518140386859386e-17), SC_(0.02747423527927399546517107784257491137116), SC_(0.9725257647207260045348289221574250886288) }}, 
      {{ SC_(16.56487274169921875), SC_(11.9547176361083984375), SC_(0.2120031416416168212890625), SC_(0.3678719213803974225296602025849517577778e-13), SC_(0.3626765412426586081242337527368141793909e-8), SC_(0.1014314818213882190545008288279278500065e-4), SC_(0.999989856851817861178094549917117207215) }}, 
      {{ SC_(16.7168407440185546875), SC_(17.211780548095703125), SC_(0.679734706878662109375), SC_(0.5255404936867314730857144059170849864992e-10), SC_(0.6713201704579517148922939230392858897661e-12), SC_(0.9873872144755256315210291318674926821626), SC_(0.01261278552447436847897086813250731783743) }}, 
      {{ SC_(16.7927150726318359375), SC_(96.29975128173828125), SC_(0.57974660396575927734375), SC_(0.1554111596773145889341558799298843484464e-20), SC_(0.1189329699553228682499916409483462758958e-41), SC_(0.9999999999999999999992347205297079862945), SC_(0.7652794702920137054593152118610564227963e-21) }}, 
      {{ SC_(16.8990039825439453125), SC_(80.91371917724609375), SC_(0.35079205036163330078125), SC_(0.1893903589863859287665077022048775851226e-19), SC_(0.7284558113956680012499742841191836454899e-24), SC_(0.9999615382853892522790641546872240359769), SC_(0.3846171461074772093584531277596402309709e-4) }}, 
      {{ SC_(17.070804595947265625), SC_(23.9502468109130859375), SC_(0.4302643835544586181640625), SC_(0.3702029717024057525719792977144457629507e-12), SC_(0.2691010536497529290537495169046104149395e-12), SC_(0.5790718609952136144260120602011740753818), SC_(0.4209281390047863855739879397988259246182) }}, 
      {{ SC_(17.1121063232421875), SC_(73.92975616455078125), SC_(0.74067318439483642578125), SC_(0.5280405885074293518312435411854031119108e-19), SC_(0.5373485890650070919093600600563529197499e-47), SC_(0.9999999999999999999999999998982372566124), SC_(0.1017627433875657040841231245138316115717e-27) }}, 
      {{ SC_(17.1186676025390625), SC_(30.191310882568359375), SC_(0.075946711003780364990234375), SC_(0.4590420410757144739016353043158825613657e-21), SC_(0.2725198983761384272444021476908625289899e-13), SC_(0.1684434920454393141892473626038158167364e-7), SC_(0.9999999831556507954560685810752637396184) }}, 
      {{ SC_(17.3388614654541015625), SC_(71.39038848876953125), SC_(0.64634835720062255859375), SC_(0.6219278725572947317578424543613973742666e-19), SC_(0.7566034540106270642458983887447764663109e-37), SC_(0.9999999999999999987834546618733100364364), SC_(0.1216545338126689963563634195679132625531e-17) }}, 
      {{ SC_(17.58744049072265625), SC_(48.637111663818359375), SC_(0.92927074432373046875), SC_(0.1580400427033062940992711223892715931891e-16), SC_(0.6975610821708038755777575829595736193365e-58), SC_(1.0), SC_(0.4413824941064828453250596540773370908102e-41) }}, 
      {{ SC_(17.8132457733154296875), SC_(31.2676944732666015625), SC_(0.730357825756072998046875), SC_(0.8137271127606893031200200197673127274407e-14), SC_(0.3186388206253888385279717184370378989271e-21), SC_(0.9999999608420558745893903546685482497064), SC_(0.3915794412541060964533145175029358442278e-7) }}, 
      {{ SC_(17.8766193389892578125), SC_(42.912654876708984375), SC_(0.802131235599517822265625), SC_(0.7219325110845885726839356782748620694039e-16), SC_(0.3980746418665576076070766720666066538769e-33), SC_(0.9999999999999999944859853829201585466432), SC_(0.5514014617079841453356754085258244026557e-17) }}, 
      {{ SC_(18.1847019195556640625), SC_(98.236053466796875), SC_(0.2583700716495513916015625), SC_(0.7908189439486929515366022606583928830617e-22), SC_(0.269699614897743849162269804382062115103e-24), SC_(0.9966012073448134172485992427557359361125), SC_(0.003398792655186582751400757244264063887456) }}, 
      {{ SC_(18.2922458648681640625), SC_(24.5019245147705078125), SC_(0.567864835262298583984375), SC_(0.1553793108114208833045214935754835713717e-12), SC_(0.5198101764629563256465612473428796681963e-14), SC_(0.9676286864930787796291178867133064398668), SC_(0.03237131350692122037088211328669356013324) }}, 
      {{ SC_(18.351116180419921875), SC_(38.57105255126953125), SC_(0.368547737598419189453125), SC_(0.1595650158595999650941597937766785252704e-15), SC_(0.4602843542939845022493964218339916910538e-16), SC_(0.776119155834894560717685891523945200218), SC_(0.223880844165105439282314108476054799782) }}, 
      {{ SC_(18.3907794952392578125), SC_(50.477100372314453125), SC_(0.296746194362640380859375), SC_(0.2178574066842946817313744518719195865507e-17), SC_(0.8437789690511836216127902982566585638851e-18), SC_(0.7208205133449736970682357891577574238536), SC_(0.2791794866550263029317642108422425761464) }}, 
      {{ SC_(18.481632232666015625), SC_(58.43822479248046875), SC_(0.43872296810150146484375), SC_(0.2556809745912072442062184230311557842604e-18), SC_(0.3278072790150444340978436844977336600489e-22), SC_(0.9998718069434293946465962791286609675036), SC_(0.0001281930565706053534037208713390324963921) }}, 
      {{ SC_(18.687259674072265625), SC_(40.87311553955078125), SC_(0.1081511080265045166015625), SC_(0.6522959633179768047353804247100162463716e-21), SC_(0.570611239611246652829878151601384494896e-16), SC_(0.1143139954808103675361108144147251480546e-4), SC_(0.9999885686004519189632463889185585274852) }}, 
      {{ SC_(18.8661975860595703125), SC_(88.4942626953125), SC_(0.95613896846771240234375), SC_(0.1351910056401104999354645890228783322755e-21), SC_(0.347400864942295191287123432716380461902e-122), SC_(1.0), SC_(0.2569703977697337877154833916591589345698e-100) }}, 
      {{ SC_(18.89550018310546875), SC_(81.18740081787109375), SC_(0.361357867717742919921875), SC_(0.5627898813106083106067922359909406868658e-21), SC_(0.3715353272812491294128860109213736863535e-25), SC_(0.9999339876544159492226591617547753577898), SC_(0.6601234558405077734083824522464221024462e-4) }}, 
      {{ SC_(19.04332733154296875), SC_(45.651042938232421875), SC_(0.751291930675506591796875), SC_(0.6462638248777118538776502604429991567738e-17), SC_(0.3725261322582575367883652441102482402876e-31), SC_(0.9999999999999942356957341880307524636437), SC_(0.5764304265811969247536356291588007620888e-14) }}, 
      {{ SC_(19.09236907958984375), SC_(59.5980987548828125), SC_(0.76244509220123291015625), SC_(0.7676674292691921347499919511359031696248e-19), SC_(0.855954426161405107794389130256708605989e-41), SC_(0.9999999999999999999998884993170836672244), SC_(0.111500682916332775555467510965662210199e-21) }}, 
      {{ SC_(19.1745243072509765625), SC_(54.286212921142578125), SC_(0.942056357860565185546875), SC_(0.3228754849973669255141943338548325923194e-18), SC_(0.4480197660390922385572158502440821218299e-69), SC_(1.0), SC_(0.1387593009864920138821234636223602060197e-50) }}, 
      {{ SC_(19.476428985595703125), SC_(44.122348785400390625), SC_(0.4232228100299835205078125), SC_(0.6436581298014894356480014944751334711139e-17), SC_(0.1694463861578001822222332361106225633163e-18), SC_(0.974349731145726981655976978912051644614), SC_(0.02565026885427301834402302108794835538601) }}, 
      {{ SC_(19.6595249176025390625), SC_(84.84677886962890625), SC_(0.15814177691936492919921875), SC_(0.1593300454212762784095445360549615086987e-22), SC_(0.5582801605997422215300682550752043385062e-22), SC_(0.2220286780823872070914743549524763022619), SC_(0.7779713219176127929085256450475236977381) }}, 
      {{ SC_(19.78098297119140625), SC_(51.385921478271484375), SC_(0.5466372966766357421875), SC_(0.3607203038289368076677162262751295763726e-18), SC_(0.7199006926871186325700716374568673204863e-24), SC_(0.9999980042729829168361574417693160846349), SC_(0.199572701708316384255823068391536510116e-5) }}, 
      {{ SC_(19.811840057373046875), SC_(86.43074798583984375), SC_(0.680438578128814697265625), SC_(0.3983729481961293313944760855190773222693e-22), SC_(0.1386644612447768888986898157261148933585e-47), SC_(0.9999999999999999999999999651922998605546), SC_(0.348077001394454071568638274512651145929e-25) }}, 
      {{ SC_(20.7742290496826171875), SC_(54.01380157470703125), SC_(0.412725269794464111328125), SC_(0.4162786434715983739806101698391799163795e-19), SC_(0.293833734305770253403264950930230379891e-21), SC_(0.9929908914058116404854925085947053201515), SC_(0.007009108594188359514507491405294679848518) }}, 
      {{ SC_(20.8934917449951171875), SC_(58.7877044677734375), SC_(0.97059571743011474609375), SC_(0.7881989724463155632290721734824437678474e-20), SC_(0.8682259048544488642928943633380231780783e-92), SC_(1.0), SC_(0.1101531383832886125995886868329430845532e-71) }}, 
      {{ SC_(22.1746730804443359375), SC_(83.121429443359375), SC_(0.4560872018337249755859375), SC_(0.1739142074176166923009720105152949208628e-23), SC_(0.1067222037148087168937862791759097803393e-30), SC_(0.9999999386351473232163600017396280191656), SC_(0.6136485267678363999826037198083439791467e-7) }}, 
      {{ SC_(22.3811931610107421875), SC_(1.77738964557647705078125), SC_(0.13206009566783905029296875), SC_(0.8439316302956905718204318651809676819388e-21), SC_(0.003580858746457181785641057338109616307986), SC_(0.2356785592647732514215053826303556328121e-18), SC_(0.9999999999999999997643214407352267485785) }}, 
      {{ SC_(22.404003143310546875), SC_(91.82765960693359375), SC_(0.90006387233734130859375), SC_(0.1646706713163086523940115461042109988871e-24), SC_(0.1645882929639846608547438664330135010911e-94), SC_(1.0), SC_(0.999499738771540230231717479553597764893e-70) }}, 
      {{ SC_(22.5921783447265625), SC_(14.78290081024169921875), SC_(0.4242243468761444091796875), SC_(0.1418521180057423870847905150196516299015e-12), SC_(0.1063585312385792604135456145578462649334e-10), SC_(0.01316162530171529181132394426207041054381), SC_(0.9868383746982847081886760557379295894562) }}, 
      {{ SC_(22.61876678466796875), SC_(47.7995758056640625), SC_(0.77493298053741455078125), SC_(0.4064727215238972439339956975447450177846e-19), SC_(0.1063157107346194002563139304836002858116e-34), SC_(0.9999999999999997384431842411622069454738), SC_(0.2615568157588377930545261667169333820496e-15) }}, 
      {{ SC_(22.766429901123046875), SC_(79.9653167724609375), SC_(0.431470692157745361328125), SC_(0.1504844669338893040579356037848228577655e-23), SC_(0.5286559595700542019121178434707654139233e-29), SC_(0.9999964869855795396305042647898260771244), SC_(0.3513014420460369495735210173922875635906e-5) }}, 
      {{ SC_(22.89769744873046875), SC_(50.549854278564453125), SC_(0.22774152457714080810546875), SC_(0.5417830273662362402339129265361806301141e-21), SC_(0.9680666671166753496424881512081070118094e-20), SC_(0.05299933414629438649884252328574133625735), SC_(0.9470006658537056135011574767142586637427) }}, 
      {{ SC_(23.048816680908203125), SC_(19.4495372772216796875), SC_(0.42181909084320068359375), SC_(0.8337369759687474122892396804851656844592e-14), SC_(0.1372318032772555779842374401371306852307e-12), SC_(0.05727428126263784823321320035093093675723), SC_(0.9427257187373621517667867996490690632428) }}, 
      {{ SC_(23.1594390869140625), SC_(40.157146453857421875), SC_(0.490352451801300048828125), SC_(0.5632810949260404739034911790306267129475e-18), SC_(0.127350832195786558065571877265155758699e-19), SC_(0.9778911014954875499217622757419529876696), SC_(0.02210889850451245007823772425804701233036) }}, 
      {{ SC_(23.4779911041259765625), SC_(55.288116455078125), SC_(0.343905150890350341796875), SC_(0.7302071589677771838332771400537165474977e-21), SC_(0.1657199710967559571398700871593189442065e-21), SC_(0.8150296318353265646780399736222077944296), SC_(0.1849703681646734353219600263777922055704) }}, 
      {{ SC_(23.623058319091796875), SC_(32.82364654541015625), SC_(0.9797503948211669921875), SC_(0.1469244755413879134308682702377911156075e-16), SC_(0.5003485334183521067663252842593777743589e-57), SC_(1.0), SC_(0.3405481160131188266997507973987308310802e-40) }}, 
      {{ SC_(23.7283573150634765625), SC_(96.86403656005859375), SC_(0.4876201450824737548828125), SC_(0.6163795038119352621883609181032831500413e-26), SC_(0.8195039556020543732822081993836064998246e-37), SC_(0.9999999999867045553831199563309383122057), SC_(0.132954446168800436690616877942503802328e-10) }}, 
      {{ SC_(23.99161529541015625), SC_(4.047111034393310546875), SC_(0.2878762185573577880859375), SC_(0.1650775901535324017050264177401078759094e-14), SC_(0.1294943622129606859895816570179719505795e-4), SC_(0.1274785923583370047463307534724391645537e-9), SC_(0.9999999998725214076416629952536692465276) }}, 
      {{ SC_(23.99320220947265625), SC_(33.300525665283203125), SC_(0.568866729736328125), SC_(0.8064936366006045944064246272360488846407e-17), SC_(0.9122323123205927505951176176899129492062e-19), SC_(0.9888154185625609984191751426210855790298), SC_(0.01118458143743900158082485737891442097022) }}, 
      {{ SC_(23.9952526092529296875), SC_(82.260498046875), SC_(0.2970997393131256103515625), SC_(0.124560997639688542491367615358076911417e-24), SC_(0.5955144609896631738840890481584589059087e-26), SC_(0.9543723519002833592939142296571480716771), SC_(0.04562764809971664070608577034285192832294) }}, 
      {{ SC_(24.0707035064697265625), SC_(41.576251983642578125), SC_(0.87595522403717041015625), SC_(0.118488450409009720549111591633108869005e-18), SC_(0.2529546292008898867416811893217785831678e-40), SC_(0.9999999999999999999997865153706308783677), SC_(0.2134846293691216323140999704092335056151e-21) }}, 
      {{ SC_(24.16912841796875), SC_(27.275302886962890625), SC_(0.3188464343547821044921875), SC_(0.3205505212593666230273925872133098875125e-17), SC_(0.2490252031108970377947168555718984344947e-15), SC_(0.01270862391776081654549628739666585122497), SC_(0.987291376082239183454503712603334148775) }}, 
      {{ SC_(24.2849597930908203125), SC_(33.197727203369140625), SC_(0.948930203914642333984375), SC_(0.6681455798171640490579715308209851464705e-17), SC_(0.1199353431782231099546747202091696178989e-44), SC_(0.9999999999999999999999999998204951932616), SC_(0.1795048067384402093827552906814460481335e-27) }}, 
      {{ SC_(24.352497100830078125), SC_(1.3539125919342041015625), SC_(0.152462780475616455078125), SC_(0.4978690735093790656962712836188504239884e-21), SC_(0.01170252329158081952400542258249700218467), SC_(0.4254373703041996642360450375264768223225e-19), SC_(0.9999999999999999999574562629695800335764) }}, 
      {{ SC_(25.1083850860595703125), SC_(95.5017547607421875), SC_(0.162266075611114501953125), SC_(0.9174772112948988715418630635487472625933e-28), SC_(0.8142785070428205789549581363043083621703e-27), SC_(0.1012638688336526420242266481055859797858), SC_(0.8987361311663473579757733518944140202142) }}, 
      {{ SC_(25.18061065673828125), SC_(65.47235870361328125), SC_(0.779189288616180419921875), SC_(0.3233105666920879356732744292188124141857e-23), SC_(0.4593993692427350256106305360070281738467e-47), SC_(0.9999999999999999999999985790771580928429), SC_(0.1420922841907157062117490694830542585229e-23) }}, 
      {{ SC_(25.4282169342041015625), SC_(33.2448272705078125), SC_(0.149199068546295166015625), SC_(0.2660058434501108166982226277372191696714e-24), SC_(0.2432981045756627375787100723534943887497e-17), SC_(0.1093332867638897269117682032562335084536e-6), SC_(0.9999998906667132361102730882317967437665) }}, 
      {{ SC_(25.479015350341796875), SC_(93.52143096923828125), SC_(0.890914142131805419921875), SC_(0.8113186773177302380349984038983900673597e-27), SC_(0.669606284776357256960282633346478519323e-93), SC_(1.0), SC_(0.8253307898569734376291367155543777803741e-66) }}, 
      {{ SC_(25.5095119476318359375), SC_(82.084075927734375), SC_(0.1338230073451995849609375), SC_(0.3283675745381596315645869183106647202168e-28), SC_(0.1453173055208968488821218581378576382562e-25), SC_(0.002254564571396468760858478034676320201182), SC_(0.9977454354286035312391415219653236797988) }}, 
      {{ SC_(25.644100189208984375), SC_(34.306179046630859375), SC_(0.996135056018829345703125), SC_(0.1105510978861693341423658719285532293829e-17), SC_(0.4451045967555666266531094221288329784645e-84), SC_(1.0), SC_(0.4026234069731949036900468401964090519526e-66) }}, 
      {{ SC_(25.750823974609375), SC_(80.97344970703125), SC_(0.1456244289875030517578125), SC_(0.7361169782173028629936134461796043374956e-28), SC_(0.1386986773822617008190635155455059233686e-25), SC_(0.005279291884020203626472458126397789118305), SC_(0.9947207081159797963735275418736022108817) }}, 
      {{ SC_(25.806468963623046875), SC_(16.2328510284423828125), SC_(0.44564163684844970703125), SC_(0.7397478364188537936458353946041615185733e-14), SC_(0.5236513045861125530200171911803126124055e-12), SC_(0.01392994128164839579567708761587086494488), SC_(0.9860700587183516042043229123841291350551) }}, 
      {{ SC_(25.987041473388671875), SC_(4.505954265594482421875), SC_(0.25435674190521240234375), SC_(0.5093036535290937013220013847725930463518e-17), SC_(0.370436414555442379931397400497703463532e-5), SC_(0.1374874697833377142947988562512932271327e-11), SC_(0.9999999999986251253021666228570520114375) }}, 
      {{ SC_(26.0727996826171875), SC_(65.92105865478515625), SC_(0.7979488372802734375), SC_(0.8853839606622513474859423635340023351318e-24), SC_(0.9583583939983373859907248050250709074022e-50), SC_(0.9999999999999999999999999891757877194714), SC_(0.1082421228052857959122425364610982929238e-25) }}, 
      {{ SC_(26.1871185302734375), SC_(32.77977752685546875), SC_(0.50790750980377197265625), SC_(0.1419918638657313061914613734935309861822e-17), SC_(0.274436264609173205296918961367394526306e-18), SC_(0.8380290551406335601670452343581810571818), SC_(0.1619709448593664398329547656418189428182) }}, 
      {{ SC_(26.2211742401123046875), SC_(4.205412387847900390625), SC_(0.449611127376556396484375), SC_(0.4891726179645602016188930047045266154038e-11), SC_(0.6607401673397383172299982691885960192483e-5), SC_(0.7403398188732652236852166432369936842297e-6), SC_(0.9999992596601811267347763147833567630063) }}, 
      {{ SC_(26.24822235107421875), SC_(18.1572971343994140625), SC_(0.472009599208831787109375), SC_(0.3800502226374158294578312141589850583557e-14), SC_(0.6551209422586791724535993914852853982927e-13), SC_(0.05483133544121073390496864313240789356609), SC_(0.9451686645587892660950313568675921064339) }}, 
      {{ SC_(26.2971286773681640625), SC_(34.021968841552734375), SC_(0.2173161208629608154296875), SC_(0.6381468722729998927009190708646332494797e-22), SC_(0.746176455133385123058942547530658291805e-18), SC_(0.85514933739290571958513967387648806311e-4), SC_(0.9999144850662607094280414860326123511937) }}, 
      {{ SC_(26.380290985107421875), SC_(9.53551769256591796875), SC_(0.2599444091320037841796875), SC_(0.1192989907941133890331368062044815347188e-17), SC_(0.8985884551665678924241198551457004195454e-9), SC_(0.1327626567532685287471402521114796952093e-8), SC_(0.9999999986723734324673147125285974788852) }}, 
      {{ SC_(26.5280895233154296875), SC_(99.6475067138671875), SC_(0.78027403354644775390625), SC_(0.3618343025308888590586525128012292148038e-28), SC_(0.5046487526997055897773091732453852265447e-70), SC_(1.0), SC_(0.1394695718924064780413564288942205486862e-41) }}, 
      {{ SC_(26.6471500396728515625), SC_(6.914005279541015625), SC_(0.8443243503570556640625), SC_(0.314705410808799498452069712779573701885e-7), SC_(0.1035147909565038820108017231625334541154e-7), SC_(0.7524873487230675084457782204693782636327), SC_(0.2475126512769324915542217795306217363673) }}, 
      {{ SC_(26.9061603546142578125), SC_(85.707244873046875), SC_(0.954947888851165771484375), SC_(0.7141295435790046103704031768967363472348e-27), SC_(0.1472746114137446057734742824909699029807e-117), SC_(1.0), SC_(0.2062295457987189699018260443113258558075e-90) }}, 
      {{ SC_(26.9119415283203125), SC_(97.18773651123046875), SC_(0.705803692340850830078125), SC_(0.360093272074334695850363517261207378281e-28), SC_(0.3161144083730442417214627305402957585842e-57), SC_(0.9999999999999999999999999999912213186725), SC_(0.8778681327536388435396661448951871354992e-29) }}, 
      {{ SC_(27.602508544921875), SC_(70.577423095703125), SC_(0.117505915462970733642578125), SC_(0.1900152026791492051384790497160230375951e-30), SC_(0.2648220612082016344004352891128855568449e-25), SC_(0.7175151436568077553411632093370821896409e-5), SC_(0.9999928248485634319224465883679066291781) }}, 
      {{ SC_(27.6922969818115234375), SC_(87.24288177490234375), SC_(0.078267715871334075927734375), SC_(0.9809422578898093752612879921418822248684e-35), SC_(0.1505771395474033222937120895294318273116e-27), SC_(0.6514549266471033147229689484609160988009e-7), SC_(0.9999999348545073352896685277031051539084) }}, 
      {{ SC_(27.849822998046875), SC_(18.8381977081298828125), SC_(0.015501900576055049896240234375), SC_(0.1098827903189685822030111402126153113949e-51), SC_(0.1591477150307547093989548894646319058513e-13), SC_(0.6904452903878270444615337255066437073202e-38), SC_(0.9999999999999999999999999999999999999931) }}, 
      {{ SC_(28.100528717041015625), SC_(26.2048816680908203125), SC_(0.849144399166107177734375), SC_(0.3175265485235158637592297123439013222179e-16), SC_(0.1638734602055871083303046827072312537844e-24), SC_(0.9999999948390627454034737891925793308354), SC_(0.5160937254596526210807420669164565245615e-8) }}, 
      {{ SC_(28.5839023590087890625), SC_(67.9819793701171875), SC_(0.1712695658206939697265625), SC_(0.2725470140207514438567513568648894660538e-28), SC_(0.1875766517111977020005383420090557058939e-25), SC_(0.001450881962075478603800071957629220121229), SC_(0.9985491180379245213961999280423707798788) }}, 
      {{ SC_(28.74981689453125), SC_(59.308696746826171875), SC_(0.957171261310577392578125), SC_(0.3983036416002021305276715421028553625675e-24), SC_(0.3617226859138664848734469419708743133752e-83), SC_(1.0), SC_(0.9081581189180945675633532355662837806899e-59) }}, 
      {{ SC_(28.9064579010009765625), SC_(5.54414272308349609375), SC_(0.87737619876861572265625), SC_(0.2092047969393002898770083922673059687881e-6), SC_(0.8642896120272476036868369103206513589813e-7), SC_(0.7076485386990090306668937855861294500923), SC_(0.2923514613009909693331062144138705499077) }}, 
      {{ SC_(29.0440673828125), SC_(7.806694507598876953125), SC_(0.779711425304412841796875), SC_(0.2336949780379693014973477489409170569774e-8), SC_(0.3222856940410499729360592673425883345117e-8), SC_(0.4203293203774450338770678700639860989116), SC_(0.5796706796225549661229321299360139010884) }}, 
      {{ SC_(29.1984081268310546875), SC_(82.463165283203125), SC_(0.663639128208160400390625), SC_(0.7386737749509805766711977408836938112593e-28), SC_(0.1324683684014067163091591366287757880773e-45), SC_(0.9999999999999999982066729198529147457215), SC_(0.1793327080147085254278500834417301214867e-17) }}, 
      {{ SC_(29.632080078125), SC_(28.780498504638671875), SC_(0.3564095199108123779296875), SC_(0.1640608454226677619955183427719991333391e-19), SC_(0.1711538332116083795740900920221854279763e-17), SC_(0.009494567292849784811583350297958704128627), SC_(0.9905054327071502151884166497020412958714) }}, 
      {{ SC_(29.6675853729248046875), SC_(65.5779876708984375), SC_(0.45855104923248291015625), SC_(0.1221452802665315183564347258696983840727e-25), SC_(0.1963647029704502190875783876568036599383e-28), SC_(0.9983949479915902622882177233502992523489), SC_(0.001605052008409737711782276649700747651122) }}, 
      {{ SC_(30.1246337890625), SC_(1.84508430957794189453125), SC_(0.417325317859649658203125), SC_(0.7908978954425474596832647425844580456189e-13), SC_(0.00171877821326211699783848491916813233203), SC_(0.4601512221318462450567588561001567801153e-10), SC_(0.99999999995398487778681537549432411439) }}, 
      {{ SC_(30.145496368408203125), SC_(31.0489959716796875), SC_(0.7161290645599365234375), SC_(0.2454993614765491985234336289951287536986e-18), SC_(0.3076154988447514117753345204285313227212e-22), SC_(0.9998747137438563358469544246167093326047), SC_(0.0001252862561436641530455753832906673953257) }}, 
      {{ SC_(30.63494873046875), SC_(10.80619144439697265625), SC_(0.3886309564113616943359375), SC_(0.8628499619494686970667356485363924002137e-16), SC_(0.4202944063222773846463549915499000950574e-10), SC_(0.2052961394613908902920644957175497510971e-5), SC_(0.9999979470386053860910970793550428245025) }}, 
      {{ SC_(31.1102294921875), SC_(8.98231601715087890625), SC_(0.4357551038265228271484375), SC_(0.2450068496647448094224796495469285417563e-14), SC_(0.5236696154471156946884950224055485405149e-9), SC_(0.4678631261789929679254181755045291869768e-5), SC_(0.9999953213687382100703207458182449547081) }}, 
      {{ SC_(31.1215038299560546875), SC_(86.26781463623046875), SC_(0.21028804779052734375), SC_(0.1442758085844540294145248632701920450906e-30), SC_(0.1578268961110786869250765857133414317659e-29), SC_(0.08375736359524626362772365520394816116989), SC_(0.9162426364047537363722763447960518388301) }}, 
      {{ SC_(31.2718906402587890625), SC_(49.1752166748046875), SC_(0.800300419330596923828125), SC_(0.2602092514049751671117966743301940393211e-23), SC_(0.1110727546290989874391555464086646724165e-38), SC_(0.9999999999999995731406395838267133364289), SC_(0.4268593604161732866635710910991390678625e-15) }}, 
      {{ SC_(31.7099475860595703125), SC_(76.375), SC_(0.0899141728878021240234375), SC_(0.2245148225910994453446182448020574938027e-37), SC_(0.2084508782385302868735758933319488819851e-28), SC_(0.107706345133442173182436734333400051472e-8), SC_(0.999999998922936548665578268175632656666) }}, 
      {{ SC_(31.87783050537109375), SC_(42.018993377685546875), SC_(0.45890295505523681640625), SC_(0.463246605600180370869612649552336566282e-22), SC_(0.211971909854679273189615896716774137069e-22), SC_(0.6860691687166119741061361604119224786487), SC_(0.3139308312833880258938638395880775213513) }}, 
      {{ SC_(31.9599742889404296875), SC_(32.532787322998046875), SC_(0.8173215389251708984375), SC_(0.242055085727612826440126610348212722593e-19), SC_(0.7156366139023785833833259399639275024218e-28), SC_(0.9999999970434968980907501439933786692605), SC_(0.2956503101909249856006621330739521605617e-8) }}, 
      {{ SC_(32.247180938720703125), SC_(30.466350555419921875), SC_(0.920882701873779296875), SC_(0.8623345539136604419718551397693675927273e-19), SC_(0.7421925232989789171074893772077540592402e-36), SC_(0.9999999999999999913932183288889814883558), SC_(0.8606781671111018511644225596947163802482e-17) }}, 
      {{ SC_(32.514568328857421875), SC_(68.2966461181640625), SC_(0.82347548007965087890625), SC_(0.1587149895155762453432024114309172558918e-27), SC_(0.1291213613620778807671388820749006135619e-55), SC_(0.9999999999999999999999999999186457676391), SC_(0.8135423236089868243826228638746462684915e-28) }}, 
      {{ SC_(33.4163055419921875), SC_(71.99709320068359375), SC_(0.543851077556610107421875), SC_(0.1340166603205718731250321303812309961631e-28), SC_(0.1662785384606884820427275934135303810369e-34), SC_(0.9999987592711849678112247133274554684109), SC_(0.1240728815032188775286672544531589053063e-5) }}, 
      {{ SC_(33.53568267822265625), SC_(12.90661716461181640625), SC_(0.508557856082916259765625), SC_(0.1356314756838095530420851292823205202512e-14), SC_(0.9939075210043804698461945627916455820101e-12), SC_(0.001362769054901638644901610310686488491542), SC_(0.9986372309450983613550983896893135115085) }}, 
      {{ SC_(33.7122650146484375), SC_(38.8569793701171875), SC_(0.19995288550853729248046875), SC_(0.2356727299359025943356228379746894739539e-28), SC_(0.1014123387827494088616895197936799295405e-21), SC_(0.2323905335352347535152490121184654849693e-6), SC_(0.9999997676094664647652464847509878815345) }}, 
      {{ SC_(33.771942138671875), SC_(88.772613525390625), SC_(0.3082362115383148193359375), SC_(0.1873809780015792407704297313761183605627e-31), SC_(0.4870254973206330804632150363494469420726e-32), SC_(0.7937062776060717877010338900325900464921), SC_(0.2062937223939282122989661099674099535079) }}, 
      {{ SC_(33.9493408203125), SC_(61.627227783203125), SC_(0.68680679798126220703125), SC_(0.5302544441349077488228838246522943893548e-27), SC_(0.7578831431608350911449967697447423645071e-38), SC_(0.9999999999857071797976825332582607589067), SC_(0.1429282020231746674173924109332697463045e-10) }}, 
      {{ SC_(34.03857421875), SC_(87.67574310302734375), SC_(0.12993355095386505126953125), SC_(0.1803077106935948870640637096290129154959e-36), SC_(0.2393834715411339708060780170340989510173e-31), SC_(0.7532113701694482952713570392311888137736e-5), SC_(0.9999924678862983055170472864296076881119) }}, 
      {{ SC_(34.112461090087890625), SC_(72.30242156982421875), SC_(0.93900763988494873046875), SC_(0.5336415447854415163371336246779582881007e-29), SC_(0.2637811032057603414870445457370328397429e-90), SC_(1.0), SC_(0.4943039120235989859437402813756723722732e-61) }}, 
      {{ SC_(34.38770294189453125), SC_(20.3759708404541015625), SC_(0.7939956188201904296875), SC_(0.1406907742990225407118688019103554274312e-15), SC_(0.3793478167492980029240052536361557042742e-18), SC_(0.997310927281696267974531161759371447172), SC_(0.002689072718303732025468838240628552828005) }}, 
      {{ SC_(34.4462432861328125), SC_(22.6227397918701171875), SC_(0.904890477657318115234375), SC_(0.1548029817388518182408610041035373519362e-16), SC_(0.14043460156325892966046081981173125342e-25), SC_(0.9999999990928172063715916494977712560676), SC_(0.9071827936284083505022287439323609935721e-9) }}, 
      {{ SC_(34.99837493896484375), SC_(90.73647308349609375), SC_(0.15769731998443603515625), SC_(0.9017564885837871484795594486132898720572e-36), SC_(0.2544171147805670434528083843498527583311e-32), SC_(0.0003543146002074322431931713119413276308965), SC_(0.9996456853997925677568068286880586723691) }}, 
      {{ SC_(35.021800994873046875), SC_(6.873857975006103515625), SC_(0.988522708415985107421875), SC_(0.8004012446882880177331891616060994145984e-8), SC_(0.4764713702859002401616601437850605159898e-14), SC_(0.9999994047097130231467820975881745911983), SC_(0.595290286976853217902411825408801667383e-6) }}, 
      {{ SC_(35.072711944580078125), SC_(99.0110015869140625), SC_(0.4018678367137908935546875), SC_(0.1689867303406513093477147048565244862741e-33), SC_(0.509166416130031563130396532935317997219e-37), SC_(0.9996987851965405942503662726899302538689), SC_(0.0003012148034594057496337273100697461310952) }}, 
      {{ SC_(35.09523773193359375), SC_(19.955120086669921875), SC_(0.2785703837871551513671875), SC_(0.2415515553900795063596814518626885165851e-23), SC_(0.1560020115029194938431914274243477386725e-15), SC_(0.1548387417077664472379396529644491349282e-7), SC_(0.9999999845161258292233552762060347035551) }}, 
      {{ SC_(35.165950775146484375), SC_(6.75953769683837890625), SC_(0.16295583546161651611328125), SC_(0.2061699497138813535986451997168518405152e-29), SC_(0.9668417827836586267924961001936302214598e-8), SC_(0.2132406288030832073146882871989409325033e-21), SC_(0.9999999999999999999997867593711969167927) }}, 
      {{ SC_(35.31585693359375), SC_(5.31525707244873046875), SC_(0.3439953327178955078125), SC_(0.2100715327193704142722043974564298032779e-18), SC_(0.1691262649854188013470405186671987917463e-6), SC_(0.1242098811424829692697877380435596651253e-11), SC_(0.9999999999987579011885751703073021226196) }}, 
      {{ SC_(36.743663787841796875), SC_(15.15741634368896484375), SC_(0.498414218425750732421875), SC_(0.1867499053825352927116770881950197288075e-16), SC_(0.1871863050417564165679929050238744456516e-13), SC_(0.0009966742840117568666317596272096988986495), SC_(0.9990033257159882431333682403727903011014) }}, 
      {{ SC_(36.84845733642578125), SC_(34.392974853515625), SC_(0.369309842586517333984375), SC_(0.1265277973410686458902625444816325545909e-23), SC_(0.2216355149380725139282795571823534333753e-21), SC_(0.005676417552777144107964127417010725377248), SC_(0.9943235824472228558920358725829892746228) }}, 
      {{ SC_(36.89165496826171875), SC_(63.430332183837890625), SC_(0.753753721714019775390625), SC_(0.1146036737368906357195023409432597845599e-28), SC_(0.1870642343592373090198574060964777150361e-44), SC_(0.9999999999999998367729163825035657011317), SC_(0.1632270836174964342988682823540156013633e-15) }}, 
      {{ SC_(36.924678802490234375), SC_(3.3268566131591796875), SC_(0.3112839162349700927734375), SC_(0.2253512427647833544915289548190558930176e-20), SC_(0.1521159843228626258967283903787895795307e-4), SC_(0.1481443543017021595119064599388595630046e-15), SC_(0.9999999999999998518556456982978404880935) }}, 
      {{ SC_(37.24097442626953125), SC_(19.5324764251708984375), SC_(0.680319011211395263671875), SC_(0.6070607719215026304030688692247244063681e-16), SC_(0.3405278024802956153228131208058721989277e-16), SC_(0.6406374963994612372811750517846151325193), SC_(0.3593625036005387627188249482153848674807) }}, 
      {{ SC_(37.62722015380859375), SC_(17.316303253173828125), SC_(0.761755049228668212890625), SC_(0.883890045750987518692667663988038174708e-15), SC_(0.1036399852577764838493012215568349243655e-15), SC_(0.8950513078048795933334741531782466369278), SC_(0.1049486921951204066665258468217533630722) }}, 
      {{ SC_(37.86093902587890625), SC_(14.01438426971435546875), SC_(0.3949687182903289794921875), SC_(0.2577903258188974492741788861912902708046e-19), SC_(0.5665228913047133844491398883989299998264e-13), SC_(0.4550393505202571552983165094987526214837e-6), SC_(0.9999995449606494797428447016834905012474) }}, 
      {{ SC_(38.044582366943359375), SC_(20.8068065643310546875), SC_(0.1819288432598114013671875), SC_(0.3864728589539304204630552387547563129278e-31), SC_(0.1711510834959331057270812703927635819804e-16), SC_(0.2258080118803997643867277066417931138815e-14), SC_(0.9999999999999977419198811960023561327229) }}, 
      {{ SC_(38.15584564208984375), SC_(21.0209064483642578125), SC_(0.0976306498050689697265625), SC_(0.9922165085159121655651903742790618110897e-41), SC_(0.1300476855802610923432900750138521083365e-16), SC_(0.7629636037648276662346347507455481487024e-24), SC_(0.9999999999999999999999992370363962351723) }}, 
      {{ SC_(38.461910247802734375), SC_(1.8211762905120849609375), SC_(0.775735080242156982421875), SC_(0.4674937613450381019589195197343275132495e-6), SC_(0.00119311501532864614024875406125334568454), SC_(0.0003916727647940013574103285451369121313057), SC_(0.9996083272352059986425896714548630878687) }}, 
      {{ SC_(38.677120208740234375), SC_(98.44525909423828125), SC_(0.910656511783599853515625), SC_(0.1785302973991065855874109328846165484218e-35), SC_(0.1694129940334421443469395724613719849065e-106), SC_(1.0), SC_(0.9489313382742952473293267436780358342068e-71) }}, 
      {{ SC_(38.97388458251953125), SC_(21.0301876068115234375), SC_(0.317167758941650390625), SC_(0.5836254826333055277583055300087489838726e-24), SC_(0.8986765805499066563936115886994917003007e-17), SC_(0.6494276777235329090800609234412776101872e-7), SC_(0.9999999350572322276467090919939076558722) }}, 
      {{ SC_(39.093780517578125), SC_(61.720489501953125), SC_(0.647781193256378173828125), SC_(0.298408423799887322602793894772531456393e-29), SC_(0.1679645712281104967291038042206808709124e-36), SC_(0.9999999437131969550032588658566178020573), SC_(0.5628680304499674113414338219794266552792e-7) }}, 
      {{ SC_(39.2227020263671875), SC_(42.208766937255859375), SC_(0.05987356603145599365234375), SC_(0.2347266324115277593381524132085758547506e-50), SC_(0.1806422889130633470297144821857271249741e-24), SC_(0.1299400233599194851411972248323944212587e-25), SC_(0.9999999999999999999999999870059976640081) }}, 
      {{ SC_(39.55152130126953125), SC_(63.64685821533203125), SC_(0.493377506732940673828125), SC_(0.7388691088080852924250405309368575692829e-30), SC_(0.8925809741565184542780230630350392003871e-32), SC_(0.988063826698800243525317436326316788524), SC_(0.01193617330119975647468256367368321147597) }}, 
      {{ SC_(39.925777435302734375), SC_(85.80992889404296875), SC_(0.6551325321197509765625), SC_(0.3577305691728921045334607097545765254507e-34), SC_(0.2282252020844359266165804052619873135509e-48), SC_(0.9999999999999936201929118857985215777562), SC_(0.637980708811420147842224381894887693076e-14) }}, 
      {{ SC_(39.97826385498046875), SC_(85.58751678466796875), SC_(0.2530306875705718994140625), SC_(0.1946733113167645147173184785607202431674e-35), SC_(0.3472947384498695368338558633446545096848e-34), SC_(0.05307891067876112320346763290663872055801), SC_(0.946921089321238876796532367093361279442) }}, 
      {{ SC_(40.1808013916015625), SC_(38.233295440673828125), SC_(0.2827450335025787353515625), SC_(0.1459629220346249520241545951505534576282e-28), SC_(0.1445263830864073117558499008565028944307e-23), SC_(0.1009929431533970583915619620739641816452e-4), SC_(0.9999899007056846602941608438037926035818) }}, 
      {{ SC_(40.39121246337890625), SC_(49.244197845458984375), SC_(0.322578489780426025390625), SC_(0.519224168541345617794119329909740994859e-29), SC_(0.854746882711933839731328245205278352009e-27), SC_(0.006037917729411629718148335143653527491571), SC_(0.9939620822705883702818516648563464725084) }}, 
      {{ SC_(40.761920928955078125), SC_(51.6047821044921875), SC_(0.82121193408966064453125), SC_(0.1561189296883866734526002007756330596404e-27), SC_(0.2400786040764572511418003347879644452706e-43), SC_(0.9999999999999998462206956224629389049912), SC_(0.1537793043775370610950088117772200566634e-15) }}, 
      {{ SC_(40.871982574462890625), SC_(13.37363910675048828125), SC_(0.4468390643596649169921875), SC_(0.1052351560797133693501611662634957748055e-18), SC_(0.5532047236899152765912915726480285662631e-13), SC_(0.190227869334147126144813160250325742679e-5), SC_(0.9999980977213066585287385518683974967426) }}, 
      {{ SC_(41.6158599853515625), SC_(43.342967987060546875), SC_(0.9928820133209228515625), SC_(0.1476906504621896307436844549318401426789e-25), SC_(0.14279808319856182341830738909651966411e-94), SC_(1.0), SC_(0.9668728707720035648844996158890952840777e-69) }}, 
      {{ SC_(41.6799468994140625), SC_(61.72791290283203125), SC_(0.655775129795074462890625), SC_(0.2647070998988936912013259902881659338126e-30), SC_(0.219688400580012768837786670362030005772e-37), SC_(0.9999999170069928493331177466432281125454), SC_(0.8299300715066688225335677188745455228309e-7) }}, 
      {{ SC_(41.726703643798828125), SC_(98.17230987548828125), SC_(0.2999017238616943359375), SC_(0.2310636608541201895524995397347808059109e-37), SC_(0.2075884911040151469970704603758315426427e-37), SC_(0.5267582977141595065194715784378225974635), SC_(0.4732417022858404934805284215621774025365) }}, 
      {{ SC_(41.774410247802734375), SC_(56.67774200439453125), SC_(0.710732758045196533203125), SC_(0.3667774541365567825982335411662626056317e-29), SC_(0.6490208025506412601634463059686652921945e-38), SC_(0.9999999982304779258308925873343055162799), SC_(0.1769522074169107412665694483720066129775e-8) }}, 
      {{ SC_(42.176128387451171875), SC_(11.24645137786865234375), SC_(0.0365376062691211700439453125), SC_(0.3936956878893107877218838455536779461661e-62), SC_(0.9727632781272948263307170274806416328512e-12), SC_(0.4047189041173819527236549253982598354258e-50), SC_(1.0) }}, 
      {{ SC_(42.28356170654296875), SC_(56.39649200439453125), SC_(0.706075489521026611328125), SC_(0.2771799080827136497794206874781534901712e-29), SC_(0.1481285781798430985358258016577060676855e-37), SC_(0.9999999946558688754589927048441860345326), SC_(0.5344131124541007295155813965467383423457e-8) }}, 
      {{ SC_(42.288570404052734375), SC_(39.47277069091796875), SC_(0.807550251483917236328125), SC_(0.1425211398867533856066726919658505255905e-24), SC_(0.2753164087611669883896951701382506052279e-33), SC_(0.9999999980682416064866776761353249429536), SC_(0.1931758393513322323864675057046403737064e-8) }}, 
      {{ SC_(42.3452911376953125), SC_(69.81468963623046875), SC_(0.8350250720977783203125), SC_(0.2523549524660565444599299317789672153441e-32), SC_(0.2167343978170344082615597477010160347774e-59), SC_(0.9999999999999999999999999991411525880548), SC_(0.8588474119452308240498150430249247091e-27) }}, 
      {{ SC_(42.416675567626953125), SC_(78.19091796875), SC_(0.4625279605388641357421875), SC_(0.5132313986381157297530998892244886591699e-34), SC_(0.3401101699402278569102910061744336975331e-36), SC_(0.9934167871800935371085502976266002715537), SC_(0.006583212819906462891449702373399728446332) }}, 
      {{ SC_(42.434902191162109375), SC_(0.3001205027103424072265625), SC_(0.91574394702911376953125), SC_(0.002768508735386755915395183541260530184407), SC_(0.9706042246192298717301490832770644169456), SC_(0.002844243156314242058287766324242276991912), SC_(0.9971557568436857579417122336757577230081) }}, 
      {{ SC_(42.52593231201171875), SC_(76.9965667724609375), SC_(0.800088465213775634765625), SC_(0.7782800864823767801619683074645393860527e-34), SC_(0.2088276038399315522047357467495758001834e-59), SC_(0.9999999999999999999999999731680653961252), SC_(0.2683193460387479707496967993173940633739e-25) }}, 
      {{ SC_(42.57288360595703125), SC_(90.0022125244140625), SC_(0.9619019031524658203125), SC_(0.3372972984473552540369360657385817773973e-36), SC_(0.4270958175231838747273714964122895850175e-130), SC_(1.0), SC_(0.1266229582890786803765561064293221149487e-93) }}, 
      {{ SC_(42.825298309326171875), SC_(72.6893157958984375), SC_(0.762955129146575927734375), SC_(0.4047832413587501058489140442917340515058e-33), SC_(0.7318353349940872220089978381534954736374e-52), SC_(0.9999999999999999998192031536341500007487), SC_(0.180796846365849999251253324649092469216e-18) }}, 
      {{ SC_(43.020740509033203125), SC_(63.306365966796875), SC_(0.4361739456653594970703125), SC_(0.2558424705347660716168938746813382298131e-31), SC_(0.860185082163269702332963192709368795747e-32), SC_(0.7483816125181208889126505696862972573329), SC_(0.2516183874818791110873494303137027426671) }}, 
      {{ SC_(43.141384124755859375), SC_(74.99410247802734375), SC_(0.257582485675811767578125), SC_(0.5433223231351340106351077066490007597444e-36), SC_(0.1011375659476980501541872271852690320289e-33), SC_(0.005343406537597923060726355483066075029993), SC_(0.99465659346240207693927364451693392497) }}, 
      {{ SC_(43.165119171142578125), SC_(35.93244171142578125), SC_(0.66931819915771484375), SC_(0.1208356501201119001291230131635063172393e-23), SC_(0.1435402063986018635465216571911000009536e-25), SC_(0.9882604914381140718254149561731405049852), SC_(0.01173950856188592817458504382685949501476) }}, 
      {{ SC_(43.2391510009765625), SC_(24.431964874267578125), SC_(0.6397993564605712890625), SC_(0.1901029840946798088624128477126000911974e-19), SC_(0.1929078562724727932005497272824907152403e-19), SC_(0.496338390611732757343296213192139368392), SC_(0.503661609388267242656703786807860631608) }}, 
      {{ SC_(43.5698699951171875), SC_(47.30150604248046875), SC_(0.4353021681308746337890625), SC_(0.5035009320752968621614839031574928696896e-28), SC_(0.201270021930247218677242399324261450596e-27), SC_(0.2001036092840194046926646486637389882317), SC_(0.7998963907159805953073353513362610117683) }}, 
      {{ SC_(43.585857391357421875), SC_(48.8617706298828125), SC_(0.385771930217742919921875), SC_(0.431708683554485754613718229226896380922e-29), SC_(0.8583333575282172701353267563386158714511e-28), SC_(0.0478875939967246900242366730760153925587), SC_(0.9521124060032753099757633269239846074413) }}, 
      {{ SC_(43.8744354248046875), SC_(12.58966350555419921875), SC_(0.0972220599651336669921875), SC_(0.2779408153593653453929050434196904475058e-46), SC_(0.7844819362364457675987939759004516412868e-13), SC_(0.3542985536324611455682203142186221525688e-33), SC_(0.9999999999999999999999999999999996457014) }}, 
      {{ SC_(43.886997222900390625), SC_(68.0406646728515625), SC_(0.441279351711273193359375), SC_(0.1166620624757361232103882528576169673598e-32), SC_(0.1955870854973536489581233313913329117386e-33), SC_(0.8564190438616872585513526999108347459931), SC_(0.1435809561383127414486473000891652540069) }}, 
      {{ SC_(44.008514404296875), SC_(48.33751678466796875), SC_(0.85304582118988037109375), SC_(0.9209271832164331065795302923382207136423e-28), SC_(0.14477261912908282637206046398245535787e-44), SC_(0.9999999999999999842796887997757292607167), SC_(0.1572031120022427073928326040297959172945e-16) }}, 
      {{ SC_(44.267826080322265625), SC_(60.42314910888671875), SC_(0.2399921715259552001953125), SC_(0.1146837867172603714188761560089961490237e-35), SC_(0.5307052879311827002444752881219896093581e-31), SC_(0.2160922664561644746189377235080810723419e-4), SC_(0.9999783907733543835525381062276491918928) }}, 
      {{ SC_(44.558620452880859375), SC_(48.756893157958984375), SC_(0.111208103597164154052734375), SC_(0.290889640260951329008504007053782479672e-46), SC_(0.4645256646690160360372128167782526295148e-28), SC_(0.6262078984768604794506338002006401255396e-18), SC_(0.9999999999999999993737921015231395205494) }}, 
      {{ SC_(44.678375244140625), SC_(75.57898712158203125), SC_(0.387357175350189208984375), SC_(0.1067223409856966481716542747148889310193e-34), SC_(0.5864919138273774389799111170630400473684e-35), SC_(0.6453489270930132554213867541716576900484), SC_(0.3546510729069867445786132458283423099516) }}, 
      {{ SC_(45.01377105712890625), SC_(97.39150238037109375), SC_(0.9817249774932861328125), SC_(0.1176893959005228253329454265028675577258e-38), SC_(0.2411480441185281725037294883396967512529e-171), SC_(1.0), SC_(0.2049021003747516834821590080440546950957e-132) }}, 
      {{ SC_(45.054157257080078125), SC_(72.049346923828125), SC_(0.2238895595073699951171875), SC_(0.3081920386384367074011496696493347387825e-38), SC_(0.6173722912738508665066150254242941132891e-34), SC_(0.4991747424141961157288243426894507468483e-4), SC_(0.9999500825257585803884271175657310549253) }}, 
      {{ SC_(45.092372894287109375), SC_(37.85004425048828125), SC_(0.3532232344150543212890625), SC_(0.1702519686403131554653243428316678286437e-28), SC_(0.8183993002261537372789972503201688348496e-25), SC_(0.0002079871749246281410957427585445040585258), SC_(0.9997920128250753718589042572414554959415) }}, 
      {{ SC_(45.37976837158203125), SC_(43.69329071044921875), SC_(0.63310039043426513671875), SC_(0.8240327477532193587671718175374598096525e-27), SC_(0.7378084847316249150952608536080263514407e-29), SC_(0.9911258254547410186428218669355714037147), SC_(0.008874174545258981357178133064428596285326) }}, 
      {{ SC_(45.742435455322265625), SC_(9.4440765380859375), SC_(0.8558895587921142578125), SC_(0.6628768211371091115425256226369829756038e-11), SC_(0.307805240224038407990471216183891961723e-11), SC_(0.682897982278135661506459523152865945281), SC_(0.317102017721864338493540476847134054719) }}, 
      {{ SC_(45.872547149658203125), SC_(53.322948455810546875), SC_(0.982362329959869384765625), SC_(0.922598634406964697044599101577791731796e-30), SC_(0.2678291653211358874354389982249023273903e-95), SC_(1.0), SC_(0.2902986795480065422042857246693659427533e-65) }}, 
      {{ SC_(45.884883880615234375), SC_(21.3772735595703125), SC_(0.4886601269245147705078125), SC_(0.2254873537345049534364695201331300668447e-21), SC_(0.3591709875137388149262982821191986367664e-18), SC_(0.0006274055799174238757679954107313740704116), SC_(0.9993725944200825761242320045892686259296) }}, 
      {{ SC_(46.07259368896484375), SC_(52.976299285888671875), SC_(0.754711210727691650390625), SC_(0.9822940271660326458827366040744619475659e-30), SC_(0.3713555036100931359275058755557717318561e-39), SC_(0.9999999996219507670823555173336006323809), SC_(0.3780492329176444826663993676191484012453e-9) }}, 
      {{ SC_(46.09163665771484375), SC_(44.64239501953125), SC_(0.917126178741455078125), SC_(0.2593276230276698835123391840118979831603e-27), SC_(0.2582932999485398068057502118449587010483e-51), SC_(0.9999999999999999999999990039884801590138), SC_(0.9960115198409861801525167993023180372191e-24) }}, 
      {{ SC_(46.244915008544921875), SC_(46.90155792236328125), SC_(0.913384497165679931640625), SC_(0.4762511565677713304793182982200549247228e-28), SC_(0.5764325290895291166347773429757503379462e-53), SC_(0.9999999999999999999999998789645922870317), SC_(0.1210354077129683170599568309422781802484e-24) }}, 
      {{ SC_(46.93906402587890625), SC_(38.72959136962890625), SC_(0.196675598621368408203125), SC_(0.4799542076187229313447422022104929925216e-38), SC_(0.1315988828380330745537393005519343638595e-25), SC_(0.3647099407441454993917337352141099004473e-12), SC_(0.9999999999996352900592558545006082662648) }}, 
      {{ SC_(47.092334747314453125), SC_(90.01831817626953125), SC_(0.4202479422092437744140625), SC_(0.2159654212187134401338381666200439163778e-38), SC_(0.7071274883471733500750180258988427082789e-40), SC_(0.9682954643471225021193064287424893195609), SC_(0.03170453565287749788069357125751068043909) }}, 
      {{ SC_(47.092426300048828125), SC_(74.85051727294921875), SC_(0.80975353717803955078125), SC_(0.2214320425532711689904343856015440166599e-35), SC_(0.1058119440402781156093750243828445106733e-59), SC_(0.9999999999999999999999995221470984045937), SC_(0.4778529015954063330103486266071020687561e-24) }}, 
      {{ SC_(47.108837127685546875), SC_(31.823215484619140625), SC_(0.585309207439422607421875), SC_(0.1828863188320426732073225691570616394776e-23), SC_(0.2609176255584225035915227100266309734293e-23), SC_(0.412088087867773940110217067612869945269), SC_(0.587911912132226059889782932387130054731) }}, 
      {{ SC_(47.135715484619140625), SC_(24.75850677490234375), SC_(0.92750012874603271484375), SC_(0.4910728838531255263272069412746118895355e-20), SC_(0.8846854484910285175236214022023439159547e-31), SC_(0.9999999999819846406192590704328647584765), SC_(0.1801535938074092956713524152349281408929e-10) }}, 
      {{ SC_(47.328884124755859375), SC_(98.7459564208984375), SC_(0.16269548237323760986328125), SC_(0.4721372997320025178350771658996384878405e-46), SC_(0.4897824289869578392435419689631140942899e-40), SC_(0.9639726063287407884109324948230953809789e-6), SC_(0.9999990360273936712592115890675051769046) }}, 
      {{ SC_(47.348602294921875), SC_(21.5629291534423828125), SC_(0.933999836444854736328125), SC_(0.1652852661527383726076459880294205310047e-18), SC_(0.8038834869464726414921229104379110718756e-28), SC_(0.9999999995136387499823277619669532665004), SC_(0.4863612500176722380330467334995737105583e-9) }}, 
      {{ SC_(47.992214202880859375), SC_(40.151958465576171875), SC_(0.54726588726043701171875), SC_(0.1155458951919561757108539976698611901077e-26), SC_(0.1073419808610594419634511878754294878221e-26), SC_(0.5184036800838493539530872587645158938378), SC_(0.4815963199161506460469127412354841061622) }}, 
      {{ SC_(48.202205657958984375), SC_(87.7573089599609375), SC_(0.763773620128631591796875), SC_(0.1824031470200957625191527347582003125071e-38), SC_(0.4119947766772003688405131739906945869242e-62), SC_(0.999999999999999999999997741295677141963), SC_(0.2258704322858037000684935802349036653957e-23) }}, 
      {{ SC_(48.537563323974609375), SC_(79.81058502197265625), SC_(0.034413881599903106689453125), SC_(0.1309817457167733832123722426451319831056e-73), SC_(0.4953447095511398191213824247176105897128e-37), SC_(0.2644254459393811568223510087333814458741e-36), SC_(0.9999999999999999999999999999999999997356) }}, 
      {{ SC_(48.679164886474609375), SC_(91.05649566650390625), SC_(0.382394731044769287109375), SC_(0.2108894996005470506922449732888253100328e-39), SC_(0.5202455453430411884064874122314344162156e-40), SC_(0.8021233413881320319088868454726765487496), SC_(0.1978766586118679680911131545273234512504) }}, 
      {{ SC_(48.860897064208984375), SC_(34.43279266357421875), SC_(0.4854271113872528076171875), SC_(0.5238036902312066668431242142988330765292e-26), SC_(0.160466944329307144902300973469605617428e-24), SC_(0.0316106182408025513381106450252755648789), SC_(0.9683893817591974486618893549747244351211) }}, 
      {{ SC_(48.889774322509765625), SC_(41.32906341552734375), SC_(0.490639984607696533203125), SC_(0.8312121315184833801858862002643209479338e-28), SC_(0.423158191669229285946680595475097228077e-27), SC_(0.1641805144754484053467281775832351865943), SC_(0.8358194855245515946532718224167648134057) }}, 
      {{ SC_(48.925262451171875), SC_(54.405612945556640625), SC_(0.3064188659191131591796875), SC_(0.9087408026211929095772174519439674830473e-35), SC_(0.4487827438379963365874699785571427612e-31), SC_(0.0002024491452261464755868084798781592182134), SC_(0.9997975508547738535244131915201218407818) }}, 
      {{ SC_(48.9687652587890625), SC_(20.41971588134765625), SC_(0.681391417980194091796875), SC_(0.1160133022807696520040365385333866796415e-18), SC_(0.2484896766750454767478601690801046707763e-18), SC_(0.3182780634965200853975076096798468836153), SC_(0.6817219365034799146024923903201531163847) }}, 
      {{ SC_(48.9764404296875), SC_(45.798915863037109375), SC_(0.10995076596736907958984375), SC_(0.1367142727967917522994462402589763400393e-50), SC_(0.1607223307411804157927532143253986349271e-28), SC_(0.8506240058013463219223826694910387387922e-22), SC_(0.9999999999999999999999149375994198653678) }}, 
      {{ SC_(48.990139007568359375), SC_(31.015598297119140625), SC_(0.578567206859588623046875), SC_(0.9639876989128766187532063646591537675544e-24), SC_(0.2679857293764921178675173489475804172373e-23), SC_(0.264552334374810757375220249382052728263), SC_(0.735447665625189242624779750617947271737) }}, 
      {{ SC_(49.0864105224609375), SC_(24.784759521484375), SC_(0.3036836087703704833984375), SC_(0.1833255362931908908934928751917946048482e-30), SC_(0.2107566117853860158195032511552172396887e-20), SC_(0.869844768922007849010986845583915929456e-10), SC_(0.9999999999130155231077992150989013154416) }}, 
      {{ SC_(49.417392730712890625), SC_(1.25388038158416748046875), SC_(0.5308444499969482421875), SC_(0.4302318756800221144879124063195245848082e-15), SC_(0.006786209549129325727017242646106248481138), SC_(0.6339796502971144116428495210229431098134e-13), SC_(0.9999999999999366020349702885588357150479) }}, 
      {{ SC_(49.836406707763671875), SC_(77.39171600341796875), SC_(0.1259840428829193115234375), SC_(0.1267543338135936900714746005026002554869e-50), SC_(0.4633895913905244473069436263327544150796e-37), SC_(0.2735372916625725915871779129563351480651e-13), SC_(0.9999999999999726462708337427408412822087) }}, 
      {{ SC_(50.0022430419921875), SC_(25.3943119049072265625), SC_(0.547260820865631103515625), SC_(0.14280788396101628929879545302001935566e-22), SC_(0.7224972443703179065239673324764800390918e-21), SC_(0.01938275540393189483339878172331426015707), SC_(0.9806172445960681051666012182766857398429) }}, 
      {{ SC_(50.0471649169921875), SC_(32.2532958984375), SC_(0.58530557155609130859375), SC_(0.2196454378374690488407896395604687372169e-24), SC_(0.4430935015253182501618347173752967366661e-24), SC_(0.3314207522628058667516266079099883865849), SC_(0.6685792477371941332483733920900116134151) }}, 
      {{ SC_(50.595706939697265625), SC_(94.0074005126953125), SC_(0.1355634629726409912109375), SC_(0.4406890682067846838031485627662151655593e-51), SC_(0.9675286231305830007759120455547891641682e-41), SC_(0.4554791017559739830157832411608425901517e-10), SC_(0.9999999999544520898244026016984216758839) }}, 
      {{ SC_(50.78582763671875), SC_(11.3192539215087890625), SC_(0.46944367885589599609375), SC_(0.7192806759929649304893176172927441291907e-21), SC_(0.1296791862402992577805198808011103150072e-12), SC_(0.5546616175324722876532247977828021972963e-8), SC_(0.999999994453383824675277123467752022172) }}, 
      {{ SC_(50.85086822509765625), SC_(39.35898590087890625), SC_(0.38867628574371337890625), SC_(0.307988136719259560581173127364180715279e-30), SC_(0.7762314244827035583420822287782416572894e-27), SC_(0.0003966162331417975934266439310375483447362), SC_(0.9996033837668582024065733560689624516553) }}, 
      {{ SC_(51.07715606689453125), SC_(87.0186767578125), SC_(0.3897998631000518798828125), SC_(0.9309238016095076520326574560015846251851e-40), SC_(0.4179691084709979050268138889755816901027e-40), SC_(0.6901391464456193305957140795717393088866), SC_(0.3098608535543806694042859204282606911134) }}, 
      {{ SC_(51.324951171875), SC_(13.80013275146484375), SC_(0.2816991508007049560546875), SC_(0.1794692338543488119197551668110217587866e-31), SC_(0.1888813555135098476661031722212177304812e-14), SC_(0.9501691332446635791287785984512367885227e-17), SC_(0.9999999999999999904983086675533642087122) }}, 
      {{ SC_(51.805210113525390625), SC_(96.9837188720703125), SC_(0.868707835674285888671875), SC_(0.7449543443464671107426844474173287907225e-42), SC_(0.2670776866792120057084273106184666695269e-90), SC_(1.0), SC_(0.3585155099853987465402929059005275059914e-48) }}, 
      {{ SC_(51.859493255615234375), SC_(93.60550689697265625), SC_(0.623473227024078369140625), SC_(0.3071599527596393727395894329717025718048e-41), SC_(0.1129854865049143538460008752471555922042e-51), SC_(0.9999999999632160750496102670872344279211), SC_(0.3678392495038973291276557207888123542958e-10) }}, 
      {{ SC_(52.11357879638671875), SC_(18.9905490875244140625), SC_(0.489815413951873779296875), SC_(0.1085484496359456265997320694847980525188e-22), SC_(0.8102110928947588989345214630492945404665e-18), SC_(0.133973721569458116909384819805436925738e-4), SC_(0.9999866026278430541883090615180194563074) }}, 
      {{ SC_(52.16498565673828125), SC_(66.7114105224609375), SC_(0.602021753787994384765625), SC_(0.1857102206603477457913656113229498706914e-35), SC_(0.3116898837564840137315853481162908905494e-39), SC_(0.9998321914763607852294920940373987410891), SC_(0.0001678085236392147705079059626012589108849) }}, 
      {{ SC_(52.68758392333984375), SC_(90.89365386962890625), SC_(0.655512332916259765625), SC_(0.4472140501732907773243865849536738224357e-41), SC_(0.4395289842031080260296528851709698791451e-53), SC_(0.9999999999990171843124509099041345810099), SC_(0.9828156875490900958654189901195890668424e-12) }}, 
      {{ SC_(52.714275360107421875), SC_(13.08054637908935546875), SC_(0.854465544223785400390625), SC_(0.3781199008368967014469878145257667971013e-14), SC_(0.588865419438887963501688854012523789433e-15), SC_(0.865250174415785644863976539518874953761), SC_(0.134749825584214355136023460481125046239) }}, 
      {{ SC_(52.8533172607421875), SC_(62.03600311279296875), SC_(0.210380852222442626953125), SC_(0.2442497536006239726583729069672535702105e-43), SC_(0.1764965100967918769447767577823413066516e-34), SC_(0.138387865645991379196282944984134883758e-8), SC_(0.9999999986161213435400862080371705501587) }}, 
      {{ SC_(53.079753875732421875), SC_(59.28238677978515625), SC_(0.18695391714572906494140625), SC_(0.3179136494758277529041550299342551501986e-45), SC_(0.84422243239812634590487463667394517592e-34), SC_(0.3765756953076388543993887130610774066599e-11), SC_(0.9999999999962342430469236114560061128694) }}, 
      {{ SC_(53.086429595947265625), SC_(63.11199188232421875), SC_(0.817645967006683349609375), SC_(0.756732425417170088366357503494301594981e-35), SC_(0.1221040882623287318248593343857185140027e-52), SC_(0.9999999999999999983864298111050889645812), SC_(0.1613570188894911035418824521388928367135e-17) }}, 
      {{ SC_(53.133392333984375), SC_(74.8609161376953125), SC_(0.823473036289215087890625), SC_(0.8480705105026343141783859369508451839103e-38), SC_(0.2586145273759825003820958107012217142445e-62), SC_(0.9999999999999999999999996950553943649015), SC_(0.3049446056350985222517637390661828529102e-24) }}, 
      {{ SC_(53.282558441162109375), SC_(94.89250946044921875), SC_(0.399842679500579833984375), SC_(0.3369237165529887015947693974258782000564e-42), SC_(0.6118532625338545066115718322623595839263e-43), SC_(0.8463101319626548105073741849094497559489), SC_(0.1536898680373451894926258150905502440511) }}, 
      {{ SC_(53.834239959716796875), SC_(54.6591949462890625), SC_(0.234856426715850830078125), SC_(0.2045044712624127509225937373981902936113e-41), SC_(0.1059291378978471026880544682035748686198e-32), SC_(0.1930578072530100703404937257703777932601e-8), SC_(0.9999999980694219274698992965950627422962) }}, 
      {{ SC_(53.912647247314453125), SC_(24.272365570068359375), SC_(0.725866377353668212890625), SC_(0.4271765123857808229840596165227832873674e-21), SC_(0.1417269071703862391965758947572408025346e-21), SC_(0.7508770341353278962278578485773376049455), SC_(0.2491229658646721037721421514226623950545) }}, 
      {{ SC_(54.659313201904296875), SC_(98.07567596435546875), SC_(0.9597480297088623046875), SC_(0.2326287956930163426967986590553519945108e-43), SC_(0.167701073150746995342724733383875186588e-139), SC_(1.0), SC_(0.7208955909828556237568907287594262654803e-96) }}, 
      {{ SC_(54.680572509765625), SC_(22.655132293701171875), SC_(0.48930370807647705078125), SC_(0.1453269075797592787843526223524176139916e-24), SC_(0.3065729257687643735331770754848651246137e-20), SC_(0.474014522022420799568228189933905692044e-4), SC_(0.9999525985477977579200431771810066094308) }}, 
      {{ SC_(54.68814849853515625), SC_(99.2881317138671875), SC_(0.01661893166601657867431640625), SC_(0.1769980011122985084129541942839869996156e-99), SC_(0.1320013543712949929541631409543706559682e-43), SC_(0.134088018986863125482261203066999761446e-55), SC_(1.0) }}, 
      {{ SC_(54.700885772705078125), SC_(71.8470001220703125), SC_(0.354702651500701904296875), SC_(0.4298343593655213053610130220174865400016e-39), SC_(0.1119014610819772158818677122649533383046e-37), SC_(0.0369909709026954428764821561447576451387), SC_(0.9630090290973045571235178438552423548613) }}, 
      {{ SC_(54.721553802490234375), SC_(15.80575847625732421875), SC_(0.14022982120513916015625), SC_(0.4200200768303977921993982196463104992055e-49), SC_(0.363462637786487290333578132333036130705e-16), SC_(0.1155607298148577895198663430350835607187e-32), SC_(0.9999999999999999999999999999999988443927) }}, 
      {{ SC_(54.78708648681640625), SC_(59.836887359619140625), SC_(0.707350790500640869140625), SC_(0.1640302213335053417747910405596123675011e-34), SC_(0.2490985328763681679515513166166162583982e-41), SC_(0.9999998481386582162411144707309858430575), SC_(0.1518613417837588855292690141569424875892e-6) }}, 
      {{ SC_(54.972362518310546875), SC_(73.27986907958984375), SC_(0.1690731346607208251953125), SC_(0.1386897915906275046583556786811205633432e-49), SC_(0.4102783590840805645502439215109027658313e-38), SC_(0.3380382818625250241169762025497981785827e-11), SC_(0.9999999999966196171813747497588302379745) }}, 
      {{ SC_(54.986019134521484375), SC_(0.809391200542449951171875), SC_(0.26599407196044921875), SC_(0.4579445475680992046361129304058491499333e-33), SC_(0.04510345939999469646069633322003083168739), SC_(0.1015320229667689420167960411773757244836e-31), SC_(0.9999999999999999999999999999999898467977) }}, 
      {{ SC_(55.015636444091796875), SC_(38.861515045166015625), SC_(0.4050408899784088134765625), SC_(0.241810132719161314040029542661462358795e-31), SC_(0.117023624109087937211509827903405868912e-27), SC_(0.0002065909159649572003896404179577688367306), SC_(0.9997934090840350427996103595820422311633) }}, 
      {{ SC_(56.1199798583984375), SC_(13.1561565399169921875), SC_(0.7447183132171630859375), SC_(0.1635343081928158419232378642386717077824e-15), SC_(0.167081783443780694931695021521110235983e-14), SC_(0.08915098927422584067029235400539953726795), SC_(0.910849010725774159329707645994600462732) }}, 
      {{ SC_(56.782161712646484375), SC_(52.737148284912109375), SC_(0.18359279632568359375), SC_(0.9658535984420670725492237420948945239739e-48), SC_(0.5565649086420601223816923684190595692905e-33), SC_(0.1735383570621820103487612055975041432809e-14), SC_(0.9999999999999982646164293781798965123879) }}, 
      {{ SC_(56.88236236572265625), SC_(39.49082183837890625), SC_(0.1948448121547698974609375), SC_(0.1966123015543364594267417355567323495441e-45), SC_(0.2457820848092585426968130309522792748167e-28), SC_(0.7999456173012742188320714496615984649094e-17), SC_(0.9999999999999999920005438269872578116793) }}, 
      {{ SC_(57.5208587646484375), SC_(75.7503662109375), SC_(0.3402856886386871337890625), SC_(0.1736663186452846596620443802863987908897e-41), SC_(0.115002127154587153997314251810535392724e-39), SC_(0.01487648776708555228041960019809414285036), SC_(0.9851235122329144477195803998019058571496) }}, 
      {{ SC_(57.620937347412109375), SC_(92.4875946044921875), SC_(0.959295451641082763671875), SC_(0.1630584747814815911374347758405239564104e-43), SC_(0.2707459011545906346332460632708959725208e-131), SC_(1.0), SC_(0.1660422137012034719773358360475518577748e-87) }}, 
      {{ SC_(57.672149658203125), SC_(51.45195770263671875), SC_(0.561601340770721435546875), SC_(0.6139807629301213730037604205141953325063e-33), SC_(0.199353238343352169304186223341083530673e-33), SC_(0.7548937607044389408205130332047427617109), SC_(0.2451062392955610591794869667952572382891) }}, 
      {{ SC_(57.852508544921875), SC_(28.1627330780029296875), SC_(0.4868429601192474365234375), SC_(0.3312564714216700008310803302986172997293e-27), SC_(0.138152099466230923182846992685626832658e-23), SC_(0.0002397191676243918065296121425079626615744), SC_(0.9997602808323756081934703878574920373384) }}, 
      {{ SC_(57.970458984375), SC_(62.738437652587890625), SC_(0.2638765275478363037109375), SC_(0.4791538495747569704085282491067207606399e-43), SC_(0.2314189241143513635033613382374618874449e-36), SC_(0.2070503750717498677199414889649189002938e-6), SC_(0.9999997929496249282501322800585110350811) }}, 
      {{ SC_(58.29863739013671875), SC_(74.733123779296875), SC_(0.77891981601715087890625), SC_(0.1090845807078067630271489883580997359858e-39), SC_(0.1069945039649694686482951786059149698162e-56), SC_(0.9999999999999999901916014829296324820553), SC_(0.9808398517070367517944692756427766818364e-17) }}, 
      {{ SC_(58.406932830810546875), SC_(90.7108612060546875), SC_(0.7943050861358642578125), SC_(0.1850872794464540084663277061267665835192e-43), SC_(0.1200044669568993925655637064338826937841e-69), SC_(0.9999999999999999999999999935163309269119), SC_(0.6483669073088128754684877671526934160181e-26) }}, 
      {{ SC_(58.526409149169921875), SC_(59.450359344482421875), SC_(0.16763903200626373291015625), SC_(0.1884264160176377508336971945268363974261e-51), SC_(0.1419647606238142099401176037169647355768e-35), SC_(0.1327275974612742714098653863305336059204e-15), SC_(0.9999999999999998672724025387257285901346) }}, 
      {{ SC_(58.52677154541015625), SC_(80.8175506591796875), SC_(0.12999321520328521728515625), SC_(0.4389971010446309366323927316823062510457e-58), SC_(0.291969914168087152130922671188422269932e-41), SC_(0.1503569647905229680222741675073014222413e-16), SC_(0.9999999999999999849643035209477031977726) }}, 
      {{ SC_(58.704471588134765625), SC_(47.663806915283203125), SC_(0.408790290355682373046875), SC_(0.1237150213924296573487566502507567512588e-34), SC_(0.8292923493946251802502134772145150420844e-32), SC_(0.001489592139120161530283338560274707716977), SC_(0.998510407860879838469716661439725292283) }}, 
      {{ SC_(58.95074462890625), SC_(23.4765605926513671875), SC_(0.77393972873687744140625), SC_(0.2229470972914133898651588303261714698058e-21), SC_(0.2890637566238864918216031092119426495791e-22), SC_(0.8852254236426948117603461291862766365739), SC_(0.1147745763573051882396538708137233634261) }}, 
      {{ SC_(59.4356231689453125), SC_(58.6764984130859375), SC_(0.798126041889190673828125), SC_(0.1290235448808050623359344535909836402469e-35), SC_(0.7172230539485546211774438545246328947927e-48), SC_(0.9999999999994441145958199000125548237185), SC_(0.5558854041800999874451762814528525832619e-12) }}, 
      {{ SC_(59.4896087646484375), SC_(44.955608367919921875), SC_(0.447639644145965576171875), SC_(0.3076656126979630982928517108287932265324e-33), SC_(0.4928840250913280228010384599738268581032e-31), SC_(0.006203427496353033035658603156442311439618), SC_(0.9937965725036469669643413968435576885604) }}, 
      {{ SC_(59.852367401123046875), SC_(97.47544097900390625), SC_(0.80915629863739013671875), SC_(0.1688958863045881769702721350946552088783e-45), SC_(0.353202321748010209845604537006447454542e-77), SC_(0.9999999999999999999999999999999790875711), SC_(0.2091242892150980810292193081717129714489e-31) }}, 
      {{ SC_(60.198192596435546875), SC_(47.1956787109375), SC_(0.2138513624668121337890625), SC_(0.1465231604352314242413008969538833471558e-46), SC_(0.5044016972010155309207828222293561591186e-32), SC_(0.2904890313579539597435343056258348425097e-14), SC_(0.9999999999999970951096864204604025646569) }}, 
      {{ SC_(60.21704864501953125), SC_(71.188079833984375), SC_(0.910573899745941162109375), SC_(0.1929363826228470581965049147878718378668e-39), SC_(0.1353606447226676846998340883783362612844e-78), SC_(0.9999999999999999999999999999999999999993), SC_(0.7015817487740054977893458966430427218066e-39) }}, 
      {{ SC_(60.28430938720703125), SC_(79.73641204833984375), SC_(0.4505965411663055419921875), SC_(0.8066804615430396480865349356961034267187e-42), SC_(0.369091754689380585155965979656184169489e-42), SC_(0.686085663877925363447856330078873165747), SC_(0.313914336122074636552143669921126834253) }}, 
      {{ SC_(60.7303924560546875), SC_(12.42726612091064453125), SC_(0.981111586093902587890625), SC_(0.2615221563043579934095450498175593232998e-14), SC_(0.1065008480431480859279022022665412441064e-22), SC_(0.9999999959276548834548917271394573243811), SC_(0.4072345116545108272860542675618949467552e-8) }}, 
      {{ SC_(60.738922119140625), SC_(28.3693904876708984375), SC_(0.94008004665374755859375), SC_(0.3513749532102269115651872442657663747075e-24), SC_(0.2110269410308438601417087796693848327596e-37), SC_(0.9999999999999399425203467549942990433264), SC_(0.6005747965324500570095667355551704367904e-13) }}, 
      {{ SC_(60.986663818359375), SC_(93.42505645751953125), SC_(0.54990518093109130859375), SC_(0.4212984143374532089623949905058022186427e-45), SC_(0.2327538406227456561774779139885092047353e-49), SC_(0.9999447562643222591017422584226500812942), SC_(0.5524373567774089825774157734991870577301e-4) }}, 
      {{ SC_(61.09586334228515625), SC_(7.8842372894287109375), SC_(0.830845534801483154296875), SC_(0.1853333874940376596721250383899492889236e-11), SC_(0.1975228400418360657845876315801936215434e-10), SC_(0.08578018389981455513243764051265087002736), SC_(0.9142198161001854448675623594873491299726) }}, 
      {{ SC_(61.346073150634765625), SC_(31.2230072021484375), SC_(0.996461689472198486328125), SC_(0.1107385558653544218426090395808642653301e-25), SC_(0.7613139895854427261313068655404966335701e-78), SC_(1.0), SC_(0.6874877350857948353586330550658187810224e-52) }}, 
      {{ SC_(61.60446929931640625), SC_(77.8897705078125), SC_(0.16241228580474853515625), SC_(0.6022260268665877117945916087215588544307e-56), SC_(0.1130978777212835385159335251246598650887e-41), SC_(0.5324821641222127535616730007268331723761e-14), SC_(0.99999999999999467517835877787246438327) }}, 
      {{ SC_(61.709087371826171875), SC_(47.276912689208984375), SC_(0.780249416828155517578125), SC_(0.1969977967458324654760540047878901512905e-32), SC_(0.7193064444007614736001786540149203468626e-39), SC_(0.999999634865874827278109163776290181359), SC_(0.3651341251727218908362237098186410068142e-6) }}, 
      {{ SC_(61.766635894775390625), SC_(47.25252532958984375), SC_(0.550201356410980224609375), SC_(0.7053890261044467784866679332737814796785e-33), SC_(0.1240326994716302682797396977311344313562e-32), SC_(0.3625344184640556384149843783501610962128), SC_(0.6374655815359443615850156216498389037872) }}, 
      {{ SC_(62.20551300048828125), SC_(43.8666839599609375), SC_(0.2769952714443206787109375), SC_(0.4125034039915180520569798377158619185351e-42), SC_(0.2857725033881596092743120243332406618257e-31), SC_(0.1443467790269758055817679827859704669489e-10), SC_(0.9999999999855653220973024194418232017214) }}, 
      {{ SC_(62.247509002685546875), SC_(77.96894073486328125), SC_(0.408778965473175048828125), SC_(0.1285640597879357182954791445897782581121e-42), SC_(0.5089288110833631236771008217844458140186e-42), SC_(0.2016713686730640427580204987284770439507), SC_(0.7983286313269359572419795012715229560493) }}, 
      {{ SC_(62.406009674072265625), SC_(17.015228271484375), SC_(0.490915000438690185546875), SC_(0.2207462383727396145269700346137980268097e-25), SC_(0.8295813096953948070764673596358425733558e-18), SC_(0.2660935461285623155695823938088845818929e-7), SC_(0.9999999733906453871437684430417606191115) }}, 
      {{ SC_(62.561859130859375), SC_(81.576904296875), SC_(0.37856256961822509765625), SC_(0.5332148013539513284763898533027970502397e-44), SC_(0.5513595142370626691987557600312582021333e-43), SC_(0.08818117425822609285045590707413433645161), SC_(0.9118188257417739071495440929258656635484) }}, 
      {{ SC_(62.797336578369140625), SC_(51.50237274169921875), SC_(0.660153448581695556640625), SC_(0.3206863292263927322422987283046393169632e-34), SC_(0.2397831187866986391271409703041048989687e-36), SC_(0.9925783078167853283934813363518280241912), SC_(0.007421692183214671606518663648171975808826) }}, 
      {{ SC_(63.235927581787109375), SC_(30.81670379638671875), SC_(0.01200087927281856536865234375), SC_(0.3823009931007334498938647010188021598714e-123), SC_(0.8065603187673428710630805942668360595349e-26), SC_(0.4739893399231439860446307577735729559567e-97), SC_(1.0) }}, 
      {{ SC_(63.578670501708984375), SC_(77.7794036865234375), SC_(0.96864354610443115234375), SC_(0.2427866270955943535326641953183436346079e-42), SC_(0.1994378770425069379528750461261886887002e-119), SC_(1.0), SC_(0.8214533041969426115916070176356942733741e-77) }}, 
      {{ SC_(63.770908355712890625), SC_(26.817638397216796875), SC_(0.870199739933013916015625), SC_(0.7302575117067114522197183559751433174605e-24), SC_(0.149522758939916328922387229237137516679e-28), SC_(0.9999795250723100689372678373823412204039), SC_(0.204749276899310627321626176587795960661e-4) }}, 
      {{ SC_(63.8530731201171875), SC_(63.336330413818359375), SC_(0.81430339813232421875), SC_(0.2298169119204215991128088249805138416507e-38), SC_(0.2444007297716008093440761129573813990254e-53), SC_(0.9999999999999989365415811686266595789784), SC_(0.1063458418831373340421021553182141079201e-14) }}, 
      {{ SC_(64.4318084716796875), SC_(54.38054656982421875), SC_(0.3936505019664764404296875), SC_(0.6558940883490999710341437116818043047738e-39), SC_(0.1212601600755603381401572627910593301629e-35), SC_(0.0005406058409995317367296343981994064965398), SC_(0.9994593941590004682632703656018005935035) }}, 
      {{ SC_(64.44428253173828125), SC_(94.97145843505859375), SC_(0.96489202976226806640625), SC_(0.7871012442599625268593353750025217202916e-47), SC_(0.8003822403946811745496526917570632519432e-141), SC_(1.0), SC_(0.1016873300901976749704364001932634138096e-93) }}, 
      {{ SC_(64.4764556884765625), SC_(23.3675441741943359375), SC_(0.757764339447021484375), SC_(0.3306107834422587723006386883668158412199e-22), SC_(0.1536631356986667658248874923259611476e-22), SC_(0.6826937614743811685425948129827268830739), SC_(0.3173062385256188314574051870172731169261) }}, 
      {{ SC_(64.6313018798828125), SC_(79.39749908447265625), SC_(0.11129163205623626708984375), SC_(0.411195610190619646163344907561073791043e-67), SC_(0.3947075813324646442014934942155366259914e-43), SC_(0.1041772769609578471654162421807874373824e-23), SC_(0.9999999999999999999999989582272303904215) }}, 
      {{ SC_(64.7617645263671875), SC_(93.4521942138671875), SC_(0.9649698734283447265625), SC_(0.1310256444071031048528851965458500168043e-46), SC_(0.106569327667661325126873402832314972577e-138), SC_(1.0), SC_(0.8133470981951074869630913439499670044921e-92) }}, 
      {{ SC_(64.77459716796875), SC_(49.332683563232421875), SC_(0.352827131748199462890625), SC_(0.9209926452674470361408773569266149857737e-40), SC_(0.6052157307367526697323098667452986268995e-34), SC_(0.1521756948748392345265239926278067712493e-5), SC_(0.9999984782430512516076547347600737219323) }}, 
      {{ SC_(64.89914703369140625), SC_(64.3180999755859375), SC_(0.6274216175079345703125), SC_(0.5581653119038225670271587835859271316145e-39), SC_(0.108261876502944437227476609535525260095e-41), SC_(0.9980641523988570707620007650325639093102), SC_(0.001935847601142929237999234967436090689767) }}, 
      {{ SC_(64.91155242919921875), SC_(25.82958984375), SC_(0.351017296314239501953125), SC_(0.1286868102487735314293328931099686173593e-35), SC_(0.1694295554864608334330766608046600550539e-23), SC_(0.7595298817800368456584512685720188519691e-12), SC_(0.9999999999992404701182199631543415487314) }}, 
      {{ SC_(65.375732421875), SC_(0.15979039669036865234375), SC_(0.52988898754119873046875), SC_(0.2644435725209656303512705468072091134615e-19), SC_(2.986977327605309068870359338628848908368), SC_(0.8853216597160206947884302103255348446693e-20), SC_(0.9999999999999999999911467834028397930521) }}, 
      {{ SC_(65.40790557861328125), SC_(52.984195709228515625), SC_(0.221111953258514404296875), SC_(0.6070587204616205645198392401693346481308e-50), SC_(0.2045681897060680973736395028049666125265e-35), SC_(0.2967512795287798386700937161130033521411e-14), SC_(0.9999999999999970324872047122016132990628) }}, 
      {{ SC_(65.44457244873046875), SC_(99.45053863525390625), SC_(0.8208587169647216796875), SC_(0.314128561995418018534726743393861755535e-48), SC_(0.1873207854312833414936184974289337863239e-81), SC_(0.9999999999999999999999999999999994036811), SC_(0.5963188582451017728514940460796371326009e-33) }}, 
      {{ SC_(65.50980377197265625), SC_(71.0703887939453125), SC_(0.11963522434234619140625), SC_(0.9197564176880496707991832646118102580245e-66), SC_(0.3698463376171686406555692469447205776982e-41), SC_(0.2486860958564088938111555089555312351617e-24), SC_(0.9999999999999999999999997513139041435911) }}, 
      {{ SC_(65.54779052734375), SC_(17.386516571044921875), SC_(0.067688621580600738525390625), SC_(0.1084831392701372439574462727855695604213e-78), SC_(0.2176302643846822134032104585113773669574e-18), SC_(0.498474509401794257602355415551359412088e-60), SC_(1.0) }}, 
      {{ SC_(65.574066162109375), SC_(79.7928619384765625), SC_(0.0451550371944904327392578125), SC_(0.2574595257559792470070270553737181380746e-91), SC_(0.1460205549673759069515308866592313434325e-43), SC_(0.1763173176635996026601629184541678865155e-47), SC_(1.0) }}, 
      {{ SC_(65.6859893798828125), SC_(18.08187103271484375), SC_(0.655814349651336669921875), SC_(0.3188241802339488591237947292879693125557e-21), SC_(0.7033206155894958705973349674723990017346e-19), SC_(0.004512670674942812014063669098956219774624), SC_(0.9954873293250571879859363309010437802254) }}, 
      {{ SC_(65.9605255126953125), SC_(42.22183990478515625), SC_(0.6225128173828125), SC_(0.1118856287734226526979425692492618740256e-31), SC_(0.739269889482900942809008609282837456062e-32), SC_(0.6021422557051059200192709113077441051655), SC_(0.3978577442948940799807290886922558948345) }}, 
      {{ SC_(66.1944732666015625), SC_(66.2300262451171875), SC_(0.9874608516693115234375), SC_(0.5973257228046684698730253800388468507769e-40), SC_(0.7504009954808194607455462679975466019371e-128), SC_(1.0), SC_(0.1256267672447463220085973450827205707251e-87) }}, 
      {{ SC_(66.200958251953125), SC_(20.59555816650390625), SC_(0.99011099338531494140625), SC_(0.1407740170230326990413205957840834137862e-20), SC_(0.1340092092852028143069615542441163851609e-42), SC_(0.9999999999999999999999048054377369390992), SC_(0.9519456226306090084592487798115608754573e-22) }}, 
      {{ SC_(66.63388824462890625), SC_(73.779083251953125), SC_(0.720521390438079833984375), SC_(0.2743009881312941624521084285307400495182e-42), SC_(0.1314156305268382537275766451313855578449e-51), SC_(0.9999999995209071926457082921997047782615), SC_(0.479092807354291707800295221738459383041e-9) }}, 
      {{ SC_(66.65279388427734375), SC_(18.5475978851318359375), SC_(0.72698199748992919921875), SC_(0.3015233954091131799218812550705400966541e-20), SC_(0.2403842120587872395466443241414803219849e-19), SC_(0.1114538474103360860398358453274997991365), SC_(0.8885461525896639139601641546725002008635) }}, 
      {{ SC_(66.78327178955078125), SC_(30.382526397705078125), SC_(0.900193154811859130859375), SC_(0.3352517160181402102856503152488854617952e-26), SC_(0.1654006895062389469672732315135097588868e-34), SC_(0.9999999950663730925910025242597842888128), SC_(0.4933626907408997475740215711187155896938e-8) }}, 
      {{ SC_(66.91753387451171875), SC_(0.831444561481475830078125), SC_(0.74996602535247802734375), SC_(0.8145710543519629924369720118731495908188e-10), SC_(0.0343528763384903349447184388751413246887), SC_(0.2371187333468739208100795866182365004746e-8), SC_(0.9999999976288126665312607918992041338176) }}, 
      {{ SC_(67.180816650390625), SC_(61.37441253662109375), SC_(0.878442823886871337890625), SC_(0.1011236481587292957577312615373619442209e-38), SC_(0.2423519382962358962553839372661633900582e-61), SC_(0.999999999999999999999976034098580400617), SC_(0.239659014195993830050668200523450417895e-22) }}, 
      {{ SC_(67.533203125), SC_(51.01088714599609375), SC_(0.907373964786529541015625), SC_(0.3053077521849901118097126798196047467687e-35), SC_(0.6859802728443453455215816184321874545184e-57), SC_(0.9999999999999999999997753151474422108399), SC_(0.2246848525577891600850296267204048987993e-21) }}, 
      {{ SC_(67.6122283935546875), SC_(47.47183990478515625), SC_(0.8767697811126708984375), SC_(0.6352210946514988124020857811986243092762e-34), SC_(0.2793070721353376124801626914024433565709e-48), SC_(0.9999999999999956029943827893097235276778), SC_(0.4397005617210690276472322169393133096055e-14) }}, 
      {{ SC_(67.87351226806640625), SC_(39.873851776123046875), SC_(0.051311306655406951904296875), SC_(0.5624573524195119636698558816178317623965e-90), SC_(0.7299318015210998424603887364601682392657e-31), SC_(0.7705615117020671925977228052630398843811e-59), SC_(1.0) }}, 
      {{ SC_(67.90167999267578125), SC_(0.832427084445953369140625), SC_(0.967698156833648681640625), SC_(0.002669338211636283074909215574942365522886), SC_(0.03109835313910119427186666183379367843075), SC_(0.07905006545785030229414545685822640260282), SC_(0.9209499345421496977058545431417735973972) }}, 
      {{ SC_(67.9135589599609375), SC_(29.905181884765625), SC_(0.492492735385894775390625), SC_(0.9589074613360492305315891864895142184308e-31), SC_(0.387598787306260838197386689305880368716e-26), SC_(0.2473907995202357302069418993846853147365e-4), SC_(0.9999752609200479764269793058100615314685) }}, 
      {{ SC_(67.97026824951171875), SC_(0.281843245029449462890625), SC_(0.119085781276226043701171875), SC_(0.24692654534959416328068134388193908978e-64), SC_(0.9742021870891525966656278324892719384746), SC_(0.2534653982736307128200889820264700506043e-64), SC_(1.0) }}, 
      {{ SC_(67.9727935791015625), SC_(29.1960773468017578125), SC_(0.51082050800323486328125), SC_(0.6508419362060425257405279602760792281285e-30), SC_(0.891838526585371652129730952593783587913e-26), SC_(0.729722279784913664020754877614060361785e-4), SC_(0.9999270277720215086335979245122385939638) }}, 
      {{ SC_(68.1971893310546875), SC_(53.472103118896484375), SC_(0.592864573001861572265625), SC_(0.2021967982304036125362299256865689405366e-36), SC_(0.629386167375796961726443188700073733425e-37), SC_(0.7626170885350042295677183480077494484012), SC_(0.2373829114649957704322816519922505515988) }}, 
      {{ SC_(68.33632659912109375), SC_(91.37195587158203125), SC_(0.95949649810791015625), SC_(0.1781328844484864621632028534460632723305e-47), SC_(0.4050336537653303470295491348924032445588e-130), SC_(1.0), SC_(0.227377249865653195927089578486328223547e-82) }}, 
      {{ SC_(68.67754364013671875), SC_(31.2507991790771484375), SC_(0.36325013637542724609375), SC_(0.1414489943358549005966620870341044960544e-37), SC_(0.5920699518077879141681660636998622449836e-27), SC_(0.2389058824900409722289947463555678515482e-10), SC_(0.9999999999761094117509959027771005253644) }}, 
      {{ SC_(68.92145538330078125), SC_(71.61006927490234375), SC_(0.2218245565891265869140625), SC_(0.3484836006997353185236443234633059748292e-54), SC_(0.2158000435035637990537312037189154662672e-42), SC_(0.1614844904762114141154690372449469568677e-11), SC_(0.9999999999983851550952378858588453096276) }}, 
      {{ SC_(69.4828643798828125), SC_(12.518276214599609375), SC_(0.085607238113880157470703125), SC_(0.3506673078818272602489382019983977558641e-76), SC_(0.470055949296685725129522488005817792572e-15), SC_(0.7460118490288401686936226816530984976089e-61), SC_(1.0) }}, 
      {{ SC_(69.51404571533203125), SC_(49.061920166015625), SC_(0.886009514331817626953125), SC_(0.5566273087181891690428165383951158417572e-35), SC_(0.3308775339615671440668137085923788791416e-51), SC_(0.9999999999999999405567192304097447932865), SC_(0.5944328076959025520671345561386028326104e-16) }}, 
      {{ SC_(69.59493255615234375), SC_(63.450199127197265625), SC_(0.811599314212799072265625), SC_(0.4471720588961423950639370486422700581225e-40), SC_(0.1272354349438582301751791729635662774497e-53), SC_(0.9999999999999715466491225012834162500564), SC_(0.2845335087749871658374994363474840755111e-13) }}, 
      {{ SC_(69.81055450439453125), SC_(82.285919189453125), SC_(0.726681768894195556640625), SC_(0.1117105716494500025338530113747785576768e-45), SC_(0.2232863915452234445426967399118992538024e-57), SC_(0.9999999999980012062578512776539524454888), SC_(0.1998793742148722346047554511235803186453e-11) }}, 
      {{ SC_(69.8745880126953125), SC_(6.544506549835205078125), SC_(0.544101715087890625), SC_(0.6866735784174258127970828640815073730152e-22), SC_(0.2061294211731609617901987195579457897255e-9), SC_(0.3331273985581856632121540525891186346042e-12), SC_(0.9999999999996668726014418143367878459474) }}, 
      {{ SC_(69.9076690673828125), SC_(41.266651153564453125), SC_(0.136154949665069580078125), SC_(0.1255506204999443785402396294096072379195e-64), SC_(0.7026552461040746412972461142298766281405e-32), SC_(0.1786802577737365883204955427583198314589e-32), SC_(0.9999999999999999999999999999999982131974) }}, 
      {{ SC_(69.9887847900390625), SC_(7.218025684356689453125), SC_(0.811892807483673095703125), SC_(0.3121933957461269023409579813039092839016e-12), SC_(0.3803821310584263915528855800260955093915e-10), SC_(0.008140549846145528419756405638680220739045), SC_(0.991859450153854471580243594361319779261) }}, 
      {{ SC_(70.10987091064453125), SC_(12.06489276885986328125), SC_(0.71849811077117919921875), SC_(0.1587862508649339809687294829903911385429e-17), SC_(0.1018190287016141716431189713124753484418e-14), SC_(0.00155706661236982944762462038669486269743), SC_(0.9984429333876301705523753796133051373026) }}, 
      {{ SC_(70.6046142578125), SC_(79.72798919677734375), SC_(0.07605908811092376708984375), SC_(0.3101697695099662217875728638995839136166e-83), SC_(0.3011626523759384037212617271703928348743e-45), SC_(0.1029907815803084113944215664485203806997e-37), SC_(0.9999999999999999999999999999999999999897) }}, 
      {{ SC_(70.92816925048828125), SC_(64.9780731201171875), SC_(0.977004349231719970703125), SC_(0.6017931911491986683345116229421862556984e-41), SC_(0.1082858264992789376693040339032838742163e-108), SC_(1.0), SC_(0.1799386036463685040652019536125087790443e-67) }}, 
      {{ SC_(70.93648529052734375), SC_(92.0874786376953125), SC_(0.1125532686710357666015625), SC_(0.1613855811185498401055148904312246468295e-73), SC_(0.1320776593488569924616472301673133983449e-48), SC_(0.1221899160798131452178964270994284030317e-24), SC_(0.9999999999999999999999998778100839201869) }}, 
      {{ SC_(71.12158203125), SC_(16.7555789947509765625), SC_(0.4509786069393157958984375), SC_(0.340784141051155212033679088499429550207e-30), SC_(0.1744490754738417059941588344757393986312e-18), SC_(0.1953487802241688593178017963038157532036e-11), SC_(0.999999999998046512197758311406821982037) }}, 
      {{ SC_(71.26944732666015625), SC_(74.69042205810546875), SC_(0.5844237804412841796875), SC_(0.4939970956487800615183527928084905955251e-44), SC_(0.4865031721056244912767188628031044831015e-46), SC_(0.9902477429050261292547562581207145623839), SC_(0.009752257094973870745243741879285437616121) }}, 
      {{ SC_(71.5037078857421875), SC_(9.86990451812744140625), SC_(0.533979713916778564453125), SC_(0.6104982503068177683738426456414848350121e-24), SC_(0.7514984433242748830713234345031628580076e-13), SC_(0.8123746039995794853674925800451581190468e-11), SC_(0.9999999999918762539600042051463250741995) }}, 
      {{ SC_(71.8358917236328125), SC_(24.5574741363525390625), SC_(0.8219211101531982421875), SC_(0.9931541264727178150231047513516159291203e-24), SC_(0.3442857206994321661319437544358385431401e-25), SC_(0.9664955705085629338408873324364869567587), SC_(0.03350442949143706615911266756351304324132) }}, 
      {{ SC_(72.12274932861328125), SC_(23.07643890380859375), SC_(0.52741873264312744140625), SC_(0.1227864882068737754849599946643734032734e-28), SC_(0.7613048085382325508867352857777065566423e-23), SC_(0.161284007134625994607734442934099509551e-5), SC_(0.9999983871599286537400539226555706590049) }}, 
      {{ SC_(72.17580413818359375), SC_(40.75019073486328125), SC_(0.929392993450164794921875), SC_(0.4192755896120802633880016432066777009717e-32), SC_(0.1890836309333689937557295238986113568186e-50), SC_(0.9999999999999999995490230396949370285781), SC_(0.4509769603050629714219156635676004317989e-18) }}, 
      {{ SC_(72.24395751953125), SC_(70.47237396240234375), SC_(0.620397984981536865234375), SC_(0.4627206560338866208542660512747694683999e-43), SC_(0.1320267629658565497281099462313755318205e-45), SC_(0.9971548465613006341929877947531079605698), SC_(0.002845153438699365807012205246892039430224) }}, 
      {{ SC_(73.02487945556640625), SC_(77.29009246826171875), SC_(0.79361820220947265625), SC_(0.2451802423261875085331138579360692639185e-45), SC_(0.1071418074761732317575772027346321540694e-61), SC_(0.9999999999999999563007987676136271507665), SC_(0.4369920123238637284923346365161627495095e-16) }}, 
      {{ SC_(73.03308868408203125), SC_(10.073848724365234375), SC_(0.47669041156768798828125), SC_(0.1366966363717646742458508189347323584974e-27), SC_(0.3968839176966916248418151726648449921672e-13), SC_(0.3444247304478361574359846899099956260649e-14), SC_(0.9999999999999965557526955216384256401531) }}, 
      {{ SC_(73.1722412109375), SC_(12.98465251922607421875), SC_(0.351724326610565185546875), SC_(0.5173007354662584962384045997929241587122e-37), SC_(0.1042407361402746236956317378952854746376e-15), SC_(0.4962558349263166093029522027681605357297e-21), SC_(0.9999999999999999999995037441650736833907) }}, 
      {{ SC_(73.7858123779296875), SC_(16.669826507568359375), SC_(0.69910681247711181640625), SC_(0.5687501530021911762664015921680541446984e-21), SC_(0.1151103898422225276713166413770770520584e-18), SC_(0.004916618095757535974011431130532918345611), SC_(0.9950833819042424640259885688694670816544) }}, 
      {{ SC_(73.84268951416015625), SC_(75.59246826171875), SC_(0.94479274749755859375), SC_(0.4301641945256120733067075957914741954198e-45), SC_(0.1795328745998542467797307513047903127284e-98), SC_(1.0), SC_(0.4173589454553377963063321921449734498711e-53) }}, 
      {{ SC_(74.3132476806640625), SC_(47.47586822509765625), SC_(0.0540447235107421875), SC_(0.7077004508033978168474355278623778602284e-97), SC_(0.2002997258283504430513188217383557312907e-35), SC_(0.3533207286613418942981883483825898126345e-61), SC_(1.0) }}, 
      {{ SC_(74.4074249267578125), SC_(68.98012542724609375), SC_(0.54705417156219482421875), SC_(0.2389274222631854603364130773981919693525e-43), SC_(0.7993176525599851329377045596903328375963e-44), SC_(0.7493195479863992750319008730697440452627), SC_(0.2506804520136007249680991269302559547373) }}, 
      {{ SC_(74.4692840576171875), SC_(62.343555450439453125), SC_(0.3609246313571929931640625), SC_(0.3159911547625975307761536250342607373476e-46), SC_(0.4824753261815702509091189272912232325466e-41), SC_(0.6549331501210430061241167964418360586912e-5), SC_(0.9999934506684987895699387588320355816394) }}, 
      {{ SC_(74.81516265869140625), SC_(98.83794403076171875), SC_(0.22349761426448822021484375), SC_(0.7796406898291386981538371540412467257428e-61), SC_(0.1082126000175631213389325640779892159517e-51), SC_(0.7204712659532187016229991120529755057993e-9), SC_(0.999999999279528734046781298377000887947) }}, 
      {{ SC_(75.126708984375), SC_(82.12459564208984375), SC_(0.13308273255825042724609375), SC_(0.2333378193927773773111181521803523970379e-72), SC_(0.2153928219762894493686626338116964986312e-47), SC_(0.1083312885043417660044029866060654742837e-24), SC_(0.9999999999999999999999998916687114956582) }}, 
      {{ SC_(75.3729095458984375), SC_(56.1557464599609375), SC_(0.18165481090545654296875), SC_(0.3659490476565417020638102881240247820373e-62), SC_(0.4612717260147309302427681978494196174422e-39), SC_(0.7933481005182072367835548232010842705674e-23), SC_(0.9999999999999999999999920665189948179276) }}, 
      {{ SC_(75.46866607666015625), SC_(80.7530975341796875), SC_(0.1132812201976776123046875), SC_(0.4349132045348217643754467291482808894331e-77), SC_(0.4126485056275980880983473561591489678026e-47), SC_(0.1053955602900733259785844939517737847726e-29), SC_(0.9999999999999999999999999999989460443971) }}, 
      {{ SC_(75.72002410888671875), SC_(39.232044219970703125), SC_(0.1739477813243865966796875), SC_(0.3021588770454128000499352402307344560809e-62), SC_(0.4456724749236721514860843951414853939014e-32), SC_(0.6779841566324280449498480646727014804588e-30), SC_(0.9999999999999999999999999999993220158434) }}, 
      {{ SC_(75.774017333984375), SC_(74.064727783203125), SC_(0.0532472543418407440185546875), SC_(0.7843122524302215120724105887756370243543e-100), SC_(0.3245923286852974538452049939418949098036e-45), SC_(0.241629941042333470796521516396381804123e-54), SC_(1.0) }}, 
      {{ SC_(76.5500030517578125), SC_(1.48916995525360107421875), SC_(0.955022037029266357421875), SC_(0.9472229701287363962093802954474171043811e-4), SC_(0.001285106022674952167270120167541176149809), SC_(0.06864788587199292880266593444650814398051), SC_(0.9313521141280070711973340655534918560195) }}, 
      {{ SC_(76.5516815185546875), SC_(5.121642589569091796875), SC_(0.100828416645526885986328125), SC_(0.4477050844366248629522341424813549012151e-78), SC_(0.5660179737606709524889600539330274885667e-8), SC_(0.7909732644389977286076738490702358966392e-70), SC_(1.0) }}, 
      {{ SC_(77.0159759521484375), SC_(97.09441375732421875), SC_(0.917201936244964599609375), SC_(0.4728390672056569622777713531877015556589e-52), SC_(0.1370207568229671143600246160029555446248e-109), SC_(1.0), SC_(0.2897830706602151558862626660010202729565e-57) }}, 
      {{ SC_(77.0285491943359375), SC_(70.8257598876953125), SC_(0.98838055133819580078125), SC_(0.1459694721243060245208038540329316308348e-44), SC_(0.5427915570398780692806753423233450558286e-139), SC_(1.0), SC_(0.3718527916423802964228057402839528947112e-94) }}, 
      {{ SC_(77.4910430908203125), SC_(97.70020294189453125), SC_(0.24360062181949615478515625), SC_(0.118722110203874318324152177364215982451e-60), SC_(0.2246110881562191280483902043718310345435e-52), SC_(0.5285674476309715612179881152787654996536e-8), SC_(0.9999999947143255236902843878201188472123) }}, 
      {{ SC_(77.57126617431640625), SC_(30.36139678955078125), SC_(0.38162028789520263671875), SC_(0.4365290561487860520114064009761492133917e-40), SC_(0.7572183457788732196518590810376141796511e-28), SC_(0.576490332784424967459789092071803410883e-12), SC_(0.9999999999994235096672155750325402109079) }}, 
      {{ SC_(77.880218505859375), SC_(45.893627166748046875), SC_(0.831231176853179931640625), SC_(0.1681340845790847450518685667375450013705e-35), SC_(0.7524426870775666381859678916836423907924e-43), SC_(0.9999999552474648262099089716910355761679), SC_(0.4475253517379009102830896442383210380215e-7) }}, 
      {{ SC_(77.90517425537109375), SC_(28.6586589813232421875), SC_(0.53287231922149658203125), SC_(0.7611406182793832129347048694620038754905e-32), SC_(0.6248723412464097929355159902495062676121e-27), SC_(0.1218058948840283761696910890511042354679e-4), SC_(0.9999878194105115971623830308910948895765) }}, 
      {{ SC_(77.91672515869140625), SC_(35.63451385498046875), SC_(0.18846313655376434326171875), SC_(0.3481599603859406900834914033256136635817e-61), SC_(0.1062536622816811278762829043124296473458e-30), SC_(0.3276686684577138518525648391384040456237e-30), SC_(0.9999999999999999999999999999996723313315) }}, 
      {{ SC_(78.02274322509765625), SC_(66.9285125732421875), SC_(0.37867152690887451171875), SC_(0.748000165690622488427842481614176802446e-48), SC_(0.1483910723467361967625755754716286549382e-43), SC_(0.5040481553583848172748432350901151573488e-4), SC_(0.9999495951844641615182725156764909884843) }}, 
      {{ SC_(78.02520751953125), SC_(87.73638916015625), SC_(0.3166187703609466552734375), SC_(0.124434121512199154676951354022329272544e-54), SC_(0.6548989840178224834419248383141284851982e-50), SC_(0.1900014510366812199956181877479581841633e-4), SC_(0.9999809998548963318780004381812252041816) }}, 
      {{ SC_(78.05196380615234375), SC_(44.8951873779296875), SC_(0.905801355838775634765625), SC_(0.4244179612125439107414722800235290690391e-35), SC_(0.1146399939844401210390370906920874781683e-50), SC_(0.9999999999999997298889197410059072861571), SC_(0.2701110802589940927138429445468837380711e-15) }}, 
      {{ SC_(78.47393035888671875), SC_(21.5109043121337890625), SC_(0.923387348651885986328125), SC_(0.1504186117725732735731833344547803067168e-22), SC_(0.1343776245560251105902593768085954624817e-27), SC_(0.9999910665028409470032543319990252325546), SC_(0.8933497159052996745668000974767445358865e-5) }}, 
      {{ SC_(79.220733642578125), SC_(87.8430633544921875), SC_(0.0421499200165271759033203125), SC_(0.3577208286393429871126264604581355194397e-112), SC_(0.2485255600641152708180284097081344195615e-50), SC_(0.1439372387077841155280521886727164979193e-61), SC_(1.0) }}, 
      {{ SC_(79.4284515380859375), SC_(43.61175537109375), SC_(0.2081472575664520263671875), SC_(0.507060152058341252415868653305812171267e-60), SC_(0.8583058938579819288325400066960630116332e-35), SC_(0.5907685775978617086283935724472311549655e-25), SC_(0.9999999999999999999999999409231422402138) }}, 
      {{ SC_(79.4831390380859375), SC_(91.7117919921875), SC_(0.3923812210559844970703125), SC_(0.4954715558091293122136018782647544938254e-53), SC_(0.1688876946394641325183069582698339322231e-51), SC_(0.02850118997119706523924201146236171840879), SC_(0.9714988100288029347607579885376382815912) }}, 
      {{ SC_(79.51999664306640625), SC_(3.6441252231597900390625), SC_(0.106742106378078460693359375), SC_(0.506837663499756538489944907999740844495e-79), SC_(0.4370665069508561067242872326960051160195e-6), SC_(0.1159635102299764008675537262079113410725e-72), SC_(1.0) }}, 
      {{ SC_(79.61838531494140625), SC_(58.284641265869140625), SC_(0.505548000335693359375), SC_(0.3130132053076185640785042373287948841924e-42), SC_(0.6653371254871177258843827527647275395457e-41), SC_(0.04493194527187850897739823355164447619901), SC_(0.955068054728121491022601766448355523801) }}, 
      {{ SC_(80.0068511962890625), SC_(66.0119476318359375), SC_(0.2551696002483367919921875), SC_(0.287942847147076989631158269801485982949e-57), SC_(0.9043664046615918679100026003543440946484e-44), SC_(0.3183917996763869130767703534288551649158e-13), SC_(0.9999999999999681608200323613086923229647) }}, 
      {{ SC_(80.028045654296875), SC_(29.7029438018798828125), SC_(0.03454263508319854736328125), SC_(0.491511063664665378412958880722167322562e-119), SC_(0.8025226600327162442601840609882262178529e-28), SC_(0.6124575518461099497773274141968733209546e-91), SC_(1.0) }}, 
      {{ SC_(80.03305816650390625), SC_(47.273212432861328125), SC_(0.632396042346954345703125), SC_(0.8218990916158339500777415300633083269816e-37), SC_(0.7334792553932808606088742660696622494644e-37), SC_(0.52842389968735849083400413406805965127), SC_(0.47157610031264150916599586593194034873) }}, 
      {{ SC_(80.10146331787109375), SC_(76.29314422607421875), SC_(0.473067760467529296875), SC_(0.5743395458277702807408364080480794742853e-48), SC_(0.2929173814511384467463906939441433043491e-47), SC_(0.1639324548692949212236071611642703304719), SC_(0.8360675451307050787763928388357296695281) }}, 
      {{ SC_(80.3364410400390625), SC_(39.69818115234375), SC_(0.652003467082977294921875), SC_(0.134691436207589682928647799405676448014e-33), SC_(0.2646750268119507388170535539670646012778e-33), SC_(0.3372627615979848220953476643442588041157), SC_(0.6627372384020151779046523356557411958843) }}, 
      {{ SC_(80.54894256591796875), SC_(48.84018707275390625), SC_(0.558312952518463134765625), SC_(0.1755001225566853953417168800591041549377e-38), SC_(0.2414016767936870056020476602071999322684e-37), SC_(0.06777330675114287836826897931253854535126), SC_(0.9322266932488571216317310206874614546487) }}, 
      {{ SC_(81.158050537109375), SC_(19.9872875213623046875), SC_(0.398798644542694091796875), SC_(0.3665982884775555253198212360572645458419e-38), SC_(0.9197364156540387445356474422072913042153e-22), SC_(0.3985905986084739463207615069860213187326e-16), SC_(0.9999999999999999601409401391526053679238) }}, 
      {{ SC_(81.4284820556640625), SC_(29.9831714630126953125), SC_(0.149379074573516845703125), SC_(0.6982570028412043509542799604604251297868e-71), SC_(0.3558115998879921122914138308932486800689e-28), SC_(0.1962434622876298883535135145487172370844e-42), SC_(1.0) }}, 
      {{ SC_(81.4723663330078125), SC_(13.5477008819580078125), SC_(0.00291815050877630710601806640625), SC_(0.3544725348792542829130836742228237900322e-208), SC_(0.9243964137380141809805286188166575556319e-17), SC_(0.3834637711821720168102471430665115413168e-191), SC_(1.0) }}, 
      {{ SC_(81.73032379150390625), SC_(36.318645477294921875), SC_(0.24421386420726776123046875), SC_(0.6593728125081805431942213458659039775863e-56), SC_(0.1139424457948100030563620513761904609992e-31), SC_(0.5786893619043365342524655353908577210164e-24), SC_(0.9999999999999999999999994213106380956635) }}, 
      {{ SC_(81.75470733642578125), SC_(23.188861846923828125), SC_(0.616083085536956787109375), SC_(0.7879881562432602604810304302066062988787e-28), SC_(0.5036652730770718478774243671569874720541e-24), SC_(0.0001564262887069987502075141941120691739456), SC_(0.9998435737112930012497924858058879308261) }}, 
      {{ SC_(81.7627716064453125), SC_(36.086071014404296875), SC_(0.392287790775299072265625), SC_(0.2551310725128531260389261020673510783503e-42), SC_(0.148513536857099032049464427335795276158e-31), SC_(0.171789776142736057793539885480934333753e-10), SC_(0.9999999999828210223857263942206460114519) }}, 
      {{ SC_(81.77606201171875), SC_(32.673664093017578125), SC_(0.79738438129425048828125), SC_(0.9582256548112587758494123495709898422928e-30), SC_(0.1845782471222133886201470043161346558852e-31), SC_(0.9811015286946116501933791852639493227374), SC_(0.01889847130538834980662081473605067726259) }}, 
      {{ SC_(81.81485748291015625), SC_(6.552445888519287109375), SC_(0.60427105426788330078125), SC_(0.9980138407032382370483621061340319467634e-22), SC_(0.7450076784411631635342661356109564292774e-10), SC_(0.1339602086773283162253156450389006259425e-11), SC_(0.9999999999986603979132267168377468435496) }}, 
      {{ SC_(81.9981231689453125), SC_(72.4453887939453125), SC_(0.821263849735260009765625), SC_(0.1751984211351533317133802649461097417749e-46), SC_(0.1437486980974893010236804111463936641199e-62), SC_(0.9999999999999999179509169282997020746269), SC_(0.8204908307170029792537314152558057317378e-16) }}, 
      {{ SC_(82.11940765380859375), SC_(32.25107574462890625), SC_(0.3443934917449951171875), SC_(0.2711020364382214693864631741189166135074e-45), SC_(0.1489241982155260479610943110038923294926e-29), SC_(0.1820402860560492565494943343550363672377e-15), SC_(0.9999999999999998179597139439507434505057) }}, 
      {{ SC_(82.34578704833984375), SC_(82.19033050537109375), SC_(0.0845274031162261962890625), SC_(0.4507434542640753964075033686720964656421e-93), SC_(0.1154448371004440793417854247584955444853e-49), SC_(0.3904405476980325962045318162782354829518e-43), SC_(1.0) }}, 
      {{ SC_(82.43762969970703125), SC_(53.209751129150390625), SC_(0.781930983066558837890625), SC_(0.1546939477631081364687608902002282167434e-39), SC_(0.407613885776723410738893047027671992254e-45), SC_(0.999997365037109574176513673646957468213), SC_(0.2634962890425823486326353042531786974817e-5) }}, 
      {{ SC_(82.53137969970703125), SC_(50.591938018798828125), SC_(0.643996536731719970703125), SC_(0.1290717854309310899876077971312410245296e-38), SC_(0.5205656310989355719355080664104180422625e-39), SC_(0.7125984776581756806300370095999944486397), SC_(0.2874015223418243193699629904000055513603) }}, 
      {{ SC_(82.581695556640625), SC_(46.2474212646484375), SC_(0.23056511580944061279296875), SC_(0.2440252516829634821844462157404042693815e-59), SC_(0.1375071647244071564731611814864955255369e-36), SC_(0.1774636632004162385468140887928139087929e-22), SC_(0.9999999999999999999999822536336799583761) }}, 
      {{ SC_(83.08286285400390625), SC_(79.3597564697265625), SC_(0.16573216021060943603515625), SC_(0.1407558125543422421871900745434939418569e-72), SC_(0.5175866650822004945324635186025322691138e-49), SC_(0.2719463657974807299804189371834146437327e-23), SC_(0.9999999999999999999999972805363420251927) }}, 
      {{ SC_(83.13797760009765625), SC_(18.9084186553955078125), SC_(0.6491506099700927734375), SC_(0.3464061746384216961762531604036107342434e-25), SC_(0.3667980290636733900617335359166964191181e-21), SC_(0.9443165870137168992099069198964763368633e-4), SC_(0.9999055683412986283100790093080103523663) }}, 
      {{ SC_(83.29167938232421875), SC_(6.926252841949462890625), SC_(0.99406909942626953125), SC_(0.2458099593489197579010346889617092007189e-10), SC_(0.3552404197448629929128601071791526830878e-16), SC_(0.9999985548189044127713671302248917683612), SC_(0.1445181095587228632869775108231638787566e-5) }}, 
      {{ SC_(84.07172393798828125), SC_(98.8521575927734375), SC_(0.147914230823516845703125), SC_(0.3894515080098424542481008399689794174025e-78), SC_(0.5821659190394222210629785353473199307771e-55), SC_(0.6689699538791967189027119713850379806955e-23), SC_(0.9999999999999999999999933103004612080328) }}, 
      {{ SC_(84.1929168701171875), SC_(1.1192586421966552734375), SC_(0.99353539943695068359375), SC_(0.004192610194520286937748996295198398373834), SC_(0.002409551768016878889219658371326459966498), SC_(0.6350359500888547463453898414858578682778), SC_(0.3649640499111452536546101585141421317222) }}, 
      {{ SC_(84.430877685546875), SC_(88.59981536865234375), SC_(0.4221454560756683349609375), SC_(0.1345314455921831704231804498106842752091e-53), SC_(0.3147910576976205059978959081970377864532e-52), SC_(0.04098517039058540359868249528660111562501), SC_(0.959014829609414596401317504713398884375) }}, 
      {{ SC_(84.43921661376953125), SC_(79.0101776123046875), SC_(0.90272581577301025390625), SC_(0.269356623366595034719923947472115289015e-49), SC_(0.3069352794060293529122215440479054736699e-85), SC_(0.9999999999999999999999999999999999988605), SC_(0.1139512648954949490158960475253451209e-35) }}, 
      {{ SC_(84.912933349609375), SC_(21.192432403564453125), SC_(0.0480394922196865081787109375), SC_(0.4955893194666494490234430865068311722563e-114), SC_(0.5551322728037611749420999368062709050695e-23), SC_(0.892740962372115386922219131975855833735e-91), SC_(1.0) }}, 
      {{ SC_(85.30310821533203125), SC_(53.393310546875), SC_(0.276097476482391357421875), SC_(0.1416837475446209124098102785425567183443e-56), SC_(0.3151411752252008870191025227374463055783e-40), SC_(0.4495881804190558374868050118971588661742e-16), SC_(0.9999999999999999550411819580944162513195) }}, 
      {{ SC_(85.55228424072265625), SC_(25.2823352813720703125), SC_(0.757527887821197509765625), SC_(0.2801160956491225382919759125256678803604e-26), SC_(0.5288487224492776268049956178326045716011e-26), SC_(0.3462648676212888384853840444560677271714), SC_(0.6537351323787111615146159555439322728286) }}, 
      {{ SC_(85.9442291259765625), SC_(61.09162139892578125), SC_(0.552925884723663330078125), SC_(0.4124849198719573414953733492178248720693e-44), SC_(0.1483480334229909382608790506759348740558e-43), SC_(0.2175593244546850149263651443247366381249), SC_(0.7824406755453149850736348556752633618751) }}, 
      {{ SC_(86.86946868896484375), SC_(67.95197296142578125), SC_(0.24792282283306121826171875), SC_(0.1930375059731885268745069445573608155437e-62), SC_(0.320984027965088009846360009261971936348e-46), SC_(0.6013928705330607205162509406360935748425e-16), SC_(0.9999999999999999398607129466939279483749) }}, 
      {{ SC_(86.92922210693359375), SC_(7.755702972412109375), SC_(0.2630449831485748291015625), SC_(0.5767509828384798030497069093872487232674e-53), SC_(0.2105440775504121352641803315803570302618e-11), SC_(0.2739336055180103668800284190155795376972e-41), SC_(1.0) }}, 
      {{ SC_(87.5371551513671875), SC_(12.0381679534912109375), SC_(0.8626918792724609375), SC_(0.2535588895042702651639130355193710852891e-16), SC_(0.6279140616537813950575387451095103616792e-16), SC_(0.2876536247325031442810801011285506772274), SC_(0.7123463752674968557189198988714493227726) }}, 
      {{ SC_(87.5942840576171875), SC_(1.6520583629608154296875), SC_(0.404268085956573486328125), SC_(0.2880680935508360964716463245730960616486e-36), SC_(0.000552977852580404504538103011307528953323), SC_(0.5209396582640716182293665120475586139463e-33), SC_(0.9999999999999999999999999999999994790603) }}, 
      {{ SC_(87.9653778076171875), SC_(32.669925689697265625), SC_(0.797300159931182861328125), SC_(0.124256599182446487187034294754930873494e-30), SC_(0.5086986561567284365625124551113941301674e-32), SC_(0.9606707473563085577545662328915901289068), SC_(0.03932925264369144224543376710840987109322) }}, 
      {{ SC_(88.18665313720703125), SC_(8.9952907562255859375), SC_(0.7481768131256103515625), SC_(0.1917624357462921118072881040249660571355e-17), SC_(0.8511469192128771513047161308882001997837e-13), SC_(0.225293790213126804734076532686415908849e-4), SC_(0.9999774706209786873195265923467313584091) }}, 
      {{ SC_(88.5167999267578125), SC_(95.92215728759765625), SC_(0.503712356090545654296875), SC_(0.9572724425966673929990500866098389866521e-56), SC_(0.3341169961840798791352656795245873560576e-56), SC_(0.741273247131761292440414824639702851033), SC_(0.258726752868238707559585175360297148967) }}, 
      {{ SC_(88.65119171142578125), SC_(50.236236572265625), SC_(0.573797285556793212890625), SC_(0.8838895388051329184448801152063867687598e-41), SC_(0.1408708076323496156608840459492761825339e-39), SC_(0.05904023059111173773755865024749350332477), SC_(0.9409597694088882622624413497525064966752) }}, 
      {{ SC_(89.09032440185546875), SC_(42.3165130615234375), SC_(0.13808752596378326416015625), SC_(0.6499222724544161757290594585510674379267e-81), SC_(0.6450451228146587050022633922589414052145e-36), SC_(0.1007560943362343390294848149876465306147e-44), SC_(1.0) }}, 
      {{ SC_(89.09224700927734375), SC_(35.534870147705078125), SC_(0.54018402099609375), SC_(0.6588834220795456122510386934969588869325e-37), SC_(0.2215915764270677454815114395044870262588e-32), SC_(0.2973325258819944622018700080795170834096e-4), SC_(0.9999702667474118005537798129991920482917) }}, 
      {{ SC_(90.0053863525390625), SC_(34.383953094482421875), SC_(0.3111712038516998291015625), SC_(0.1220306196425977657790346560494124381179e-52), SC_(0.7150175001723680732496048653512851923852e-32), SC_(0.1706680180739353209370307976262919268469e-20), SC_(0.9999999999999999999982933198192606467906) }}, 
      {{ SC_(90.2716064453125), SC_(30.18273162841796875), SC_(0.3018971383571624755859375), SC_(0.3978926756665914524073447155801629299466e-53), SC_(0.1874805106989450128321837863021572572603e-29), SC_(0.2122314869866793398707756323759674736925e-23), SC_(0.9999999999999999999999978776851301332066) }}, 
      {{ SC_(90.3720550537109375), SC_(38.475521087646484375), SC_(0.53838860988616943359375), SC_(0.2703536609333038819253443374040633129714e-38), SC_(0.3697968216152121345708085774808275408623e-34), SC_(0.7310335875572521946416250731590029945788e-4), SC_(0.9999268966412442747805358374926840997005) }}, 
      {{ SC_(90.47222137451171875), SC_(26.44765472412109375), SC_(0.549768626689910888671875), SC_(0.7811911235841978762202866093317285966293e-34), SC_(0.3952557619938164995003716874121495919664e-27), SC_(0.1976418927449631469004008965479357991554e-6), SC_(0.9999998023581072550368530995991034520642) }}, 
      {{ SC_(90.48809051513671875), SC_(72.66544342041015625), SC_(0.4388004839420318603515625), SC_(0.1211051262108057317913208933050954194039e-51), SC_(0.8052995142246951042142524889328596109692e-49), SC_(0.00150159379670008006695178491155129917309), SC_(0.9984984062032999199330482150884487008269) }}, 
      {{ SC_(90.579193115234375), SC_(83.5008544921875), SC_(0.0047337622381746768951416015625), SC_(0.1981069207200380276384924503631427979567e-212), SC_(0.1737518141946380789986444149527249553236e-52), SC_(0.1140171811375259521284809083332118481335e-159), SC_(1.0) }}, 
      {{ SC_(90.6308135986328125), SC_(84.8088836669921875), SC_(0.795220434665679931640625), SC_(0.6430787672783366206039895259574980658222e-53), SC_(0.7550036479040107613920393808710247375276e-69), SC_(0.999999999999999882595463212171200076308), SC_(0.1174045367878287999236920019920484170027e-15) }}, 
      {{ SC_(91.06475830078125), SC_(13.29960346221923828125), SC_(0.2581388950347900390625), SC_(0.806910651719252187560647430281567867503e-57), SC_(0.379317285543678585993969432728484785162e-17), SC_(0.2127270974647782033023167128407244200697e-39), SC_(0.9999999999999999999999999999999999999998) }}, 
      {{ SC_(91.32868194580078125), SC_(1.8066270351409912109375), SC_(0.504820525646209716796875), SC_(0.48407981485243580216829478637920569348e-29), SC_(0.0002657183214133363826093356639601329906935), SC_(0.1821778085446462829384250917653645070406e-25), SC_(0.9999999999999999999999999817822191455354) }}, 
      {{ SC_(91.33373260498046875), SC_(55.826877593994140625), SC_(0.2290540635585784912109375), SC_(0.2949333414227013326457119970743986464045e-66), SC_(0.1618418906877080935751781288865119321706e-42), SC_(0.1822354769642477656416705539841413260615e-23), SC_(0.9999999999999999999999981776452303575223) }}, 
      {{ SC_(91.33758544921875), SC_(22.103404998779296875), SC_(0.008193102665245532989501953125), SC_(0.2422065629736929669180118188956776295952e-192), SC_(0.3010297807246223399205743044950527444429e-24), SC_(0.8045933607986114966152620340336994476393e-168), SC_(1.0) }}, 
      {{ SC_(91.57355499267578125), SC_(63.9763336181640625), SC_(0.040567062795162200927734375), SC_(0.2909024746011558429343508034278888328055e-130), SC_(0.7170113578168145819333254669888579858617e-46), SC_(0.4057152950643732604257605552196837246079e-84), SC_(1.0) }}, 
      {{ SC_(91.59912109375), SC_(65.52132415771484375), SC_(0.912586271762847900390625), SC_(0.179905041145488281396727178218983973491e-46), SC_(0.1976189166214079335958012025204842131968e-74), SC_(0.9999999999999999999999999998901537636949), SC_(0.1098462363050708135613420006073096079804e-27) }}, 
      {{ SC_(91.71936798095703125), SC_(69.523284912109375), SC_(0.170790970325469970703125), SC_(0.137298772709890694092701913934115684283e-77), SC_(0.5344906320448489479576222507564953931518e-48), SC_(0.2568777907006796621013521352120924429406e-29), SC_(0.999999999999999999999999999997431222093) }}, 
      {{ SC_(91.742431640625), SC_(80.176300048828125), SC_(0.950227081775665283203125), SC_(0.1001107102701496758482172879825461687447e-51), SC_(0.4363674030870381660841751091381232725007e-108), SC_(1.0), SC_(0.4358848338099856653448549117193567190292e-56) }}, 
      {{ SC_(92.033203125), SC_(39.246906280517578125), SC_(0.69485914707183837890625), SC_(0.3429603695399085196479912729784230311888e-35), SC_(0.4568842822110191193956928476545785495226e-35), SC_(0.4287837254261052363447145924559889366464), SC_(0.5712162745738947636552854075440110633536) }}, 
      {{ SC_(92.3379669189453125), SC_(64.45505523681640625), SC_(0.4359149932861328125), SC_(0.1865276169340167763205291709996432353182e-50), SC_(0.3113144092675435028788977675902943909337e-46), SC_(0.5991256300190186593748026830039317039068e-4), SC_(0.9999400874369980981340625197316996068296) }}, 
      {{ SC_(92.88541412353515625), SC_(24.4138278961181640625), SC_(0.47481119632720947265625), SC_(0.3517087569118679257544224321978885705116e-38), SC_(0.5033547361837899810418297479760310574297e-26), SC_(0.6987294081667341495372864749025001962669e-12), SC_(0.9999999999993012705918332658504627135251) }}, 
      {{ SC_(92.92636871337890625), SC_(21.723785400390625), SC_(0.15452297031879425048828125), SC_(0.1496355919808997710160646497363599642223e-78), SC_(0.4033357831201168472873957975134700875523e-24), SC_(0.3709950821207872136467177497502667334427e-54), SC_(1.0) }}, 
      {{ SC_(92.9385986328125), SC_(45.849689483642578125), SC_(0.3805077970027923583984375), SC_(0.7123009475318467090796828077561395619685e-50), SC_(0.260666357059090116628536966680822451934e-38), SC_(0.2732615576349308826639148876145050880397e-11), SC_(0.9999999999972673844236506911733608511239) }}, 
      {{ SC_(93.399322509765625), SC_(68.135955810546875), SC_(0.0497494600713253021240234375), SC_(0.6905215639710705512278514815975036528166e-125), SC_(0.6864215712687726843530898730264241411204e-48), SC_(0.1005972995129974563314022676955487947004e-76), SC_(1.0) }}, 
      {{ SC_(93.40106964111328125), SC_(96.49663543701171875), SC_(0.18903611600399017333984375), SC_(0.7657063231082140070082353793406337177991e-78), SC_(0.2555891770317885383063245635780211930521e-57), SC_(0.2995847993254348083418454071685611149657e-20), SC_(0.9999999999999999999970041520067456519166) }}, 
      {{ SC_(93.90015411376953125), SC_(24.007595062255859375), SC_(0.403971731662750244140625), SC_(0.9335734346720279535279023803571936252236e-44), SC_(0.7613169380702204900368864669107621241774e-26), SC_(0.1226261216568281958863292968272309752221e-17), SC_(0.9999999999999999987737387834317180411367) }}, 
      {{ SC_(94.20505523681640625), SC_(95.4943389892578125), SC_(0.3371889293193817138671875), SC_(0.9297654369865549462825173884928826911307e-63), SC_(0.2873180569011825880858826754896885391403e-57), SC_(0.3236004163085036181879114898511069822143e-5), SC_(0.9999967639958369149638181208851014889302) }}, 
      {{ SC_(94.2736968994140625), SC_(13.12218475341796875), SC_(0.709393918514251708984375), SC_(0.4136446298056877569444391910150569799517e-22), SC_(0.3591337944167607654097996956175751590464e-17), SC_(0.1151770933278035243241152703989893222014e-4), SC_(0.9999884822906672196475675884729601010678) }}, 
      {{ SC_(94.36226654052734375), SC_(75.62816619873046875), SC_(0.86930525302886962890625), SC_(0.7332140206931858197543993390917094119579e-51), SC_(0.494193161847161404627682054188893296014e-74), SC_(0.999999999999999999999993259905731481408), SC_(0.674009426851859198700510182276484925711e-23) }}, 
      {{ SC_(94.47872161865234375), SC_(4.794428348541259765625), SC_(0.3019829094409942626953125), SC_(0.2037612994500144366883878655315176352494e-51), SC_(0.5445271727836805564325394307425243332438e-8), SC_(0.3741985884898362402462482734954103002849e-43), SC_(1.0) }}, 
      {{ SC_(94.5174102783203125), SC_(2.595887660980224609375), SC_(0.9688708782196044921875), SC_(0.337761821443508199381120070196992983155e-5), SC_(0.7003104354886139691687572520659797605122e-5), SC_(0.3253740952886229454250383398376993551864), SC_(0.6746259047113770545749616601623006448136) }}, 
      {{ SC_(95.02220916748046875), SC_(49.05890655517578125), SC_(0.095445640385150909423828125), SC_(0.1014296591921831167485134416924426771213e-100), SC_(0.3255049410331931492209518274123644776711e-40), SC_(0.3116071260553918747274711046692546109596e-60), SC_(1.0) }}, 
      {{ SC_(95.16304779052734375), SC_(87.8050537109375), SC_(0.68924558162689208984375), SC_(0.3591386390171570330217034323842412396658e-55), SC_(0.3500715414450358091351879835688815561025e-61), SC_(0.9999990252477395079575524827693321958401), SC_(0.974752260492042447517230667804159929911e-6) }}, 
      {{ SC_(95.61345672607421875), SC_(65.196868896484375), SC_(0.3377856314182281494140625), SC_(0.4333859722014505980501156640750924994333e-58), SC_(0.2842452980133411144067320657040665393916e-47), SC_(0.1524690030842662316266754200421873949762e-10), SC_(0.9999999999847530996915733768373324579958) }}, 
      {{ SC_(95.71669769287109375), SC_(10.986175537109375), SC_(0.0333652384579181671142578125), SC_(0.3372800085083612728245814732509161788213e-143), SC_(0.3482559491895011198520376372913856125954e-15), SC_(0.9684831208004220966663378958012853318006e-128), SC_(1.0) }}, 
      {{ SC_(95.7506866455078125), SC_(99.6461334228515625), SC_(0.01787211932241916656494140625), SC_(0.7925981877666200622765224435998813190314e-170), SC_(0.5647605029015430138123291624587681412693e-59), SC_(0.140342354625460930114931308563781999924e-110), SC_(1.0) }}, 
      {{ SC_(95.7693939208984375), SC_(72.4906005859375), SC_(0.872441589832305908203125), SC_(0.4388142633049923644259492345034689476008e-50), SC_(0.6107180919399320674461648364002632421015e-72), SC_(0.9999999999999999999998608253780676540823), SC_(0.1391746219323459176926850046732349646854e-21) }}, 
      {{ SC_(95.92913818359375), SC_(58.095668792724609375), SC_(0.1387105882167816162109375), SC_(0.1152963776753726723714207279128040302867e-87), SC_(0.1964676344164222838212765957522296319386e-44), SC_(0.5868466733355003420468381699190122888759e-43), SC_(1.0) }}, 
      {{ SC_(95.94924163818359375), SC_(50.36627197265625), SC_(0.043119497597217559814453125), SC_(0.1205105244843612170118997464853132481334e-133), SC_(0.5379464386572334970803452281919284791023e-41), SC_(0.2240195599866172144586170468512280290734e-92), SC_(1.0) }}, 
      {{ SC_(95.974395751953125), SC_(57.37546539306640625), SC_(0.12707412242889404296875), SC_(0.5509848073830600725513709899102562059558e-91), SC_(0.3907686547756237468365485949936283442849e-44), SC_(0.1410002569677527400672535793471909277884e-46), SC_(1.0) }}, 
      {{ SC_(96.18981170654296875), SC_(97.99256134033203125), SC_(0.240151941776275634765625), SC_(0.1047338624529782694403256402509401725883e-72), SC_(0.1274994550921882776529206680489908409938e-58), SC_(0.8214455691379210750681642067899947422341e-14), SC_(0.9999999999999917855443086207892493183579) }}, 
      {{ SC_(96.3088531494140625), SC_(60.5928192138671875), SC_(0.488668859004974365234375), SC_(0.1173424000075725323832188274859866785982e-48), SC_(0.1455980145613272932867048313858796718915e-45), SC_(0.0008052850602336237442086193512349341441502), SC_(0.9991947149397663762557913806487650658558) }}, 
      {{ SC_(96.48885345458984375), SC_(96.76949310302734375), SC_(0.0185489989817142486572265625), SC_(0.1435982258016881740011473579074188068313e-169), SC_(0.2405150906117843685469869117960864428404e-58), SC_(0.5970445573141612300096758741661990216964e-111), SC_(1.0) }}, 
      {{ SC_(96.86492919921875), SC_(33.23390960693359375), SC_(0.822622716426849365234375), SC_(0.3896126830362454261608108680217826494112e-32), SC_(0.575732196536069935996623203779523859796e-34), SC_(0.985438141759546703124794958382314271643), SC_(0.01456185824045329687520504161768572835698) }}, 
      {{ SC_(97.0592803955078125), SC_(98.11096954345703125), SC_(0.0319296605885028839111328125), SC_(0.2998869565906142596550640980837126732485e-148), SC_(0.6376859616143078939902779400501204314318e-59), SC_(0.4702737313386163666185665116771431706157e-89), SC_(1.0) }}, 
      {{ SC_(97.297454833984375), SC_(14.22172069549560546875), SC_(0.62565600872039794921875), SC_(0.4586358283116612515366441141888728005777e-27), SC_(0.2345703889146973155066568361856950228888e-18), SC_(0.1955216212655529321825058592196298245196e-8), SC_(0.9999999980447837873444706781749414078037) }}, 
      {{ SC_(97.86806488037109375), SC_(23.2400360107421875), SC_(0.580998599529266357421875), SC_(0.4847838580994435860838596547982930354105e-33), SC_(0.1112477977342289130957389321924258614326e-25), SC_(0.4357693786731819507126485869030923714513e-7), SC_(0.9999999564230621326818049287351413096908) }}, 
      {{ SC_(97.9748382568359375), SC_(35.46381378173828125), SC_(0.43892610073089599609375), SC_(0.2873257135274528993245007467042681059185e-45), SC_(0.1374390079964617837539348395028823804413e-33), SC_(0.2090568883720763685344749440226251580624e-11), SC_(0.9999999999979094311162792363146552505598) }}, 
      {{ SC_(98.16379547119140625), SC_(49.7869415283203125), SC_(0.7558143138885498046875), SC_(0.3971958028052333965608830276024843615237e-41), SC_(0.2499072385121668210487453408177231300208e-43), SC_(0.9937475495928450856212412081950470642903), SC_(0.006252450407154914378758791804952935709679) }}, 
      {{ SC_(98.2663421630859375), SC_(89.943603515625), SC_(0.79222810268402099609375), SC_(0.9703020130843336605117450383730907257821e-57), SC_(0.9342902223591938348587142832364306200003e-73), SC_(0.9999999999999999037114001866973304919699), SC_(0.962885998133026695080301263760365136479e-16) }}, 
      {{ SC_(98.3052520751953125), SC_(55.438030242919921875), SC_(0.711244642734527587890625), SC_(0.9148851548605620864233078020635181477222e-44), SC_(0.2676495491351328940765645110959640891094e-45), SC_(0.9715765392732393467357708912202385044325), SC_(0.02842346072676065326422910877976149556749) }}, 
      {{ SC_(98.4063720703125), SC_(29.338825225830078125), SC_(0.679551780223846435546875), SC_(0.7234863966571889292957198162735201822678e-32), SC_(0.6644618653733999798962457728260649872896e-30), SC_(0.01077102753452599131081375931128823317142), SC_(0.9892289724654740086891862406887117668286) }}, 
      {{ SC_(98.79819488525390625), SC_(76.92431640625), SC_(0.498594343662261962890625), SC_(0.8547721404370727048220658289647343126557e-54), SC_(0.1805898574966365262303134358305105727825e-52), SC_(0.04519314170159976658173488989109380979713), SC_(0.9548068582984002334182651101089061902029) }}, 
      {{ SC_(99.61347198486328125), SC_(44.7584381103515625), SC_(0.2373598515987396240234375), SC_(0.4979063210905853961279025180666656173251e-69), SC_(0.6862752454273526015268742998992848087559e-39), SC_(0.7255198616125700349403582088841519836769e-30), SC_(0.9999999999999999999999999999992744801384) }}, 
      {{ SC_(99.90804290771484375), SC_(67.421295166015625), SC_(0.73282539844512939453125), SC_(0.4022690295295743797802135225234299639637e-49), SC_(0.3062978751814600527884142222488817508074e-53), SC_(0.9999238632526556439070749307531342152962), SC_(0.7613674734435609292506924686578470377178e-4) }}
   } };


