#ifndef TEST_COMPRESSDEV_TEST_BUFFERS_H_
#define TEST_COMPRESSDEV_TEST_BUFFERS_H_

/*
 * These test buffers are snippets obtained
 * from the Canterbury and Calgary Corpus
 * collection.
 */

/* Snippet of Alice's Adventures in Wonderland */
static const char test_buf_alice[] =
	"  Alice was beginning to get very tired of sitting by her sister\n"
	"on the bank, and of having nothing to do:  once or twice she had\n"
	"peeped into the book her sister was reading, but it had no\n"
	"pictures or conversations in it, `and what is the use of a book,'\n"
	"thought Alice `without pictures or conversation?'\n\n"
	"  So she was considering in her own mind (as well as she could,\n"
	"for the hot day made her feel very sleepy and stupid), whether\n"
	"the pleasure of making a daisy-chain would be worth the trouble\n"
	"of getting up and picking the daisies, when suddenly a White\n"
	"Rabbit with pink eyes ran close by her.\n\n"
	"  There was nothing so VERY remarkable in that; nor did Alice\n"
	"think it so VERY much out of the way to hear the Rabbit say to\n"
	"itself, `Oh dear!  Oh dear!  I shall be late!'  (when she thought\n"
	"it over afterwards, it occurred to her that she ought to have\n"
	"wondered at this, but at the time it all seemed quite natural);\n"
	"but when the Rabbit actually TOOK A WATCH OUT OF ITS WAISTCOAT-\n"
	"POCKET, and looked at it, and then hurried on, Alice started to\n"
	"her feet, for it flashed across her mind that she had never\n"
	"before seen a rabbit with either a waistcoat-pocket, or a watch to\n"
	"take out of it, and burning with curiosity, she ran across the\n"
	"field after it, and fortunately was just in time to see it pop\n"
	"down a large rabbit-hole under the hedge.\n\n"
	"  In another moment down went Alice after it, never once\n"
	"considering how in the world she was to get out again.\n\n"
	"  The rabbit-hole went straight on like a tunnel for some way,\n"
	"and then dipped suddenly down, so suddenly that Alice had not a\n"
	"moment to think about stopping herself before she found herself\n"
	"falling down a very deep well.\n\n"
	"  Either the well was very deep, or she fell very slowly, for she\n"
	"had plenty of time as she went down to look about her and to\n"
	"wonder what was going to happen next.  First, she tried to look\n"
	"down and make out what she was coming to, but it was too dark to\n"
	"see anything; then she looked at the sides of the well, and\n"
	"noticed that they were filled with cupboards and book-shelves;\n"
	"here and there she saw maps and pictures hung upon pegs.  She\n"
	"took down a jar from one of the shelves as she passed; it was\n"
	"labelled `ORANGE MARMALADE', but to her great disappointment it\n"
	"was empty:  she did not like to drop the jar for fear of killing\n"
	"somebody, so managed to put it into one of the cupboards as she\n"
	"fell past it.\n\n"
	"  `Well!' thought Alice to herself, `after such a fall as this, I\n"
	"shall think nothing of tumbling down stairs!  How brave they'll\n"
	"all think me at home!  Why, I wouldn't say anything about it,\n"
	"even if I fell off the top of the house!' (Which was very likely\n"
	"true.)\n\n"
	"  Down, down, down.  Would the fall NEVER come to an end!  `I\n"
	"wonder how many miles I've fallen by this time?' she said aloud.\n"
	"`I must be getting somewhere near the centre of the earth.  Let\n"
	"me see:  that would be four thousand miles down, I think--' (for,\n"
	"you see, Alice had learnt several things of this sort in her\n"
	"lessons in the schoolroom, and though this was not a VERY good\n"
	"opportunity for showing off her knowledge, as there was no one to\n"
	"listen to her, still it was good practice to say it over) `--yes,\n"
	"that's about the right distance--but then I wonder what Latitude\n"
	"or Longitude I've got to?'  (Alice had no idea what Latitude was,\n"
	"or Longitude either, but thought they were nice grand words to\n"
	"say.)\n\n"
	"  Presently she began again.  `I wonder if I shall fall right\n"
	"THROUGH the earth!  How funny it'll seem to come out among the\n"
	"people that walk with their heads downward!  The Antipathies, I\n"
	"think--' (she was rather glad there WAS no one listening, this\n"
	"time, as it didn't sound at all the right word) `--but I shall\n"
	"have to ask them what the name of the country is, you know.\n"
	"Please, Ma'am, is this New Zealand or Australia?' (and she tried\n"
	"to curtsey as she spoke--fancy CURTSEYING as you're falling\n"
	"through the air!  Do you think you could manage it?)  `And what\n"
	"an ignorant little girl she'll think me for asking!  No, it'll\n"
	"never do to ask:  perhaps I shall see it written up somewhere.'\n"
	"  Down, down, down.  There was nothing else to do, so Alice soon\n"
	"began talking again.  `Dinah'll miss me very much to-night, I\n"
	"should think!'  (Dinah was the cat.)  `I hope they'll remember\n"
	"her saucer of milk at tea-time.  Dinah my dear!  I wish you were\n"
	"down here with me!  There are no mice in the air, I'm afraid, but\n"
	"you might catch a bat, and that's very like a mouse, you know.\n"
	"But do cats eat bats, I wonder?'  And here Alice began to get\n"
	"rather sleepy, and went on saying to herself, in a dreamy sort of\n"
	"way, `Do cats eat bats?  Do cats eat bats?' and sometimes, `Do\n"
	"bats eat cats?' for, you see, as she couldn't answer either\n"
	"question, it didn't much matter which way she put it.  She felt\n"
	"that she was dozing off, and had just begun to dream that she\n"
	"was walking hand in hand with Dinah, and saying to her very\n"
	"earnestly, `Now, Dinah, tell me the truth:  did you ever eat a\n"
	"bat?' when suddenly, thump! thump! down she came upon a heap of\n"
	"sticks and dry leaves, and the fall was over.\n\n";

/* Snippet of Shakespeare play */
static const char test_buf_shakespeare[] =
	"CHARLES	wrestler to Frederick.\n"
	"\n"
	"\n"
	"OLIVER		|\n"
	"		|\n"
	"JAQUES (JAQUES DE BOYS:)  	|  sons of Sir Rowland de Boys.\n"
	"		|\n"
	"ORLANDO		|\n"
	"\n"
	"\n"
	"ADAM	|\n"
	"	|  servants to Oliver.\n"
	"DENNIS	|\n"
	"\n"
	"\n"
	"TOUCHSTONE	a clown.\n"
	"\n"
	"SIR OLIVER MARTEXT	a vicar.\n"
	"\n"
	"\n"
	"CORIN	|\n"
	"	|  shepherds.\n"
	"SILVIUS	|\n"
	"\n"
	"\n"
	"WILLIAM	a country fellow in love with Audrey.\n"
	"\n"
	"	A person representing HYMEN. (HYMEN:)\n"
	"\n"
	"ROSALIND	daughter to the banished duke.\n"
	"\n"
	"CELIA	daughter to Frederick.\n"
	"\n"
	"PHEBE	a shepherdess.\n"
	"\n"
	"AUDREY	a country wench.\n"
	"\n"
	"	Lords, pages, and attendants, &c.\n"
	"	(Forester:)\n"
	"	(A Lord:)\n"
	"	(First Lord:)\n"
	"	(Second Lord:)\n"
	"	(First Page:)\n"
	"	(Second Page:)\n"
	"\n"
	"\n"
	"SCENE	Oliver's house; Duke Frederick's court; and the\n"
	"	Forest of Arden.\n"
	"\n"
	"\n"
	"\n"
	"\n"
	"	AS YOU LIKE IT\n"
	"\n"
	"\n"
	"ACT I\n"
	"\n"
	"\n"
	"\n"
	"SCENE I	Orchard of Oliver's house.\n"
	"\n"
	"\n"
	"	[Enter ORLANDO and ADAM]\n"
	"\n"
	"ORLANDO	As I remember, Adam, it was upon this fashion\n"
	"	bequeathed me by will but poor a thousand crowns,\n"
	"	and, as thou sayest, charged my brother, on his\n"
	"	blessing, to breed me well: and there begins my\n"
	"	sadness. My brother Jaques he keeps at school, and\n"
	"	report speaks goldenly of his profit: for my part,\n"
	"	he keeps me rustically at home, or, to speak more\n"
	"	properly, stays me here at home unkept; for call you\n"
	"	that keeping for a gentleman of my birth, that\n"
	"	differs not from the stalling of an ox? His horses\n"
	"	are bred better; for, besides that they are fair\n"
	"	with their feeding, they are taught their manage,\n"
	"	and to that end riders dearly hired: but I, his\n"
	"	brother, gain nothing under him but growth; for the\n"
	"	which his animals on his dunghills are as much\n"
	"	bound to him as I. Besides this nothing that he so\n"
	"	plentifully gives me, the something that nature gave\n"
	"	me his countenance seems to take from me: he lets\n"
	"	me feed with his hinds, bars me the place of a\n"
	"	brother, and, as much as in him lies, mines my\n"
	"	gentility with my education. This is it, Adam, that\n"
	"	grieves me; and the spirit of my father, which I\n"
	"	think is within me, begins to mutiny against this\n"
	"	servitude: I will no longer endure it, though yet I\n"
	"	know no wise remedy how to avoid it.\n"
	"\n"
	"ADAM	Yonder comes my master, your brother.\n"
	"\n"
	"ORLANDO	Go apart, Adam, and thou shalt hear how he will\n";

/* Snippet of source code in Pascal */
static const char test_buf_pascal[] =
	"	Ptr    = 1..DMem;\n"
	"	Loc    = 1..IMem;\n"
	"	Loc0   = 0..IMem;\n"
	"	EdgeT  = (hout,lin,hin,lout); {Warning this order is important in}\n"
	"				      {predicates such as gtS,geS}\n"
	"	CardT  = (finite,infinite);\n"
	"	ExpT   = Minexp..Maxexp;\n"
	"	ManT   = Mininf..Maxinf; \n"
	"	Pflag  = (PNull,PSoln,PTrace,PPrint);\n"
	"	Sreal  = record\n"
	"		    edge:EdgeT;\n"
	"		    cardinality:CardT;\n"
	"		    exp:ExpT; {exponent}\n"
	"		    mantissa:ManT;\n"
	"		 end;\n"
	"	Int    = record\n"
	"		    hi:Sreal;\n"
	"		    lo:Sreal;\n"
	"	 end;\n"
	"	Instr  = record\n"
	"		    Code:OpType;\n"
	"		    Pars: array[0..Par] of 0..DMem;\n"
	"		 end;\n"
	"	DataMem= record\n"
	"		    D        :array [Ptr] of Int;\n"
	"		    S        :array [Loc] of State;\n"
	"		    LastHalve:Loc;\n"
	"		    RHalve   :array [Loc] of real;\n"
	"		 end;\n"
	"	DataFlags=record\n"
	"		    PF	     :array [Ptr] of Pflag;\n"
	"		 end;\n"
	"var\n"
	"	Debug  : (none,activity,post,trace,dump);\n"
	"	Cut    : (once,all);\n"
	"	GlobalEnd,Verifiable:boolean;\n"
	"	HalveThreshold:real;\n"
	"	I      : array [Loc] of Instr; {Memory holding instructions}\n"
	"	End    : Loc; {last instruction in I}\n"
	"	ParN   : array [OpType] of -1..Par; {number of parameters for each \n"
	"			opcode. -1 means no result}\n"
	"        ParIntersect : array [OpType] of boolean ;\n"
	"	DInit  : DataMem; {initial memory which is cleared and \n"
	"				used in first call}\n"
	"	DF     : DataFlags; {hold flags for variables, e.g. print/trace}\n"
	"	MaxDMem:0..DMem;\n"
	"	Shift  : array[0..Digits] of 1..maxint;{array of constant multipliers}\n"
	"						{used for alignment etc.}\n"
	"	Dummy  :Positive;\n"
	"	{constant intervals and Sreals}\n"
	"	PlusInfS,MinusInfS,PlusSmallS,MinusSmallS,ZeroS,\n"
	"	PlusFiniteS,MinusFiniteS:Sreal;\n"
	"	Zero,All,AllFinite:Int;\n"
	"\n"
	"procedure deblank;\n"
	"var Ch:char;\n"
	"begin\n"
	"   while (not eof) and (input^ in [' ','	']) do read(Ch);\n"
	"end;\n"
	"\n"
	"procedure InitialOptions;\n"
	"\n"
	"#include '/user/profs/cleary/bin/options.i';\n"
	"\n"
	"   procedure Option;\n"
	"   begin\n"
	"      case Opt of\n"
	"      'a','A':Debug:=activity;\n"
	"      'd','D':Debug:=dump;\n"
	"      'h','H':HalveThreshold:=StringNum/100;\n"
	"      'n','N':Debug:=none;\n"
	"      'p','P':Debug:=post;\n"
	"      't','T':Debug:=trace;\n"
	"      'v','V':Verifiable:=true;\n"
	"      end;\n"
	"   end;\n"
	"\n"
	"begin\n"
	"   Debug:=trace;\n"
	"   Verifiable:=false;\n"
	"   HalveThreshold:=67/100;\n"
	"   Options;\n"
	"   writeln(Debug);\n"
	"   writeln('Verifiable:',Verifiable);\n"
	"   writeln('Halve threshold',HalveThreshold);\n"
	"end;{InitialOptions}\n"
	"\n"
	"procedure NormalizeUp(E,M:integer;var S:Sreal;var Closed:boolean);\n"
	"begin\n"
	"with S do\n"
	"begin\n"
	"   if M=0 then S:=ZeroS else\n"
	"   if M>0 then\n";

static const char * const compress_test_bufs[] = {
	test_buf_alice,
	test_buf_shakespeare,
	test_buf_pascal
};

#endif /* TEST_COMPRESSDEV_TEST_BUFFERS_H_ */
