#!/bin/bash
###############################################################################
# (c) Copyright Hewlett-Packard Development Company, L.P., 2006
#
#   This program is free software: you can redistribute it and/or modify
#   it under the terms of version 2 the GNU General Public License as
#   published by the Free Software Foundation.
#   
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#   
#   You should have received a copy of the GNU General Public License
#   along with this program.  If not, see <http://www.gnu.org/licenses/>.
###############################################################################
#
# PURPOSE:
# Test the ability to filter based on device + inode number, including
# for events generated by a hard link or symlink to the audited object.

source filter_functions.bash || exit 2

# setup
inode=$(stat -c '%i' $tmp1)
dev=$(get_fs_dev $tmp1)

# stat returns hex numbers and auditctl wants decimal
major=$(stat -Lc '%t' $dev)
major=$((0x$major))
minor=$(stat -Lc '%T' $dev)
minor=$((0x$minor))

event_obj=$(get_event_obj $1)
[[ $event_obj != $tmp1 ]] && prepend_cleanup "rm -f $event_obj"

auditctl -a exit,always -S open -F key=$tmp1 -F inode=$inode \
    -F devmajor=$major -F devminor=$minor

prepend_cleanup "
    auditctl -d exit,always -S open -F key=$tmp1 -F inode=$inode \
-F devmajor=$major -F devminor=$minor"

log_mark=$(stat -c %s $audit_log)

# test
do_open_file $event_obj

# verify audit record
augrok --seek=$log_mark type==SYSCALL key==$tmp1 \
    || exit_fail "Expected record not found."

exit_pass
